@extends('admin.layouts.main')
@section('content')
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title"> {{ trans('messages.Notifications') }}</h3>
            </div>

        </div>
    </div>
    <!-- Main content -->
    <section class="content">
        <div class="box">
            <div class="box-header">
                <form action="{{ route('notification.index') }}" method="GET">
                    <div class="row">
                        <div class="col-4">
                            <div class="app-menu">
                                <div class="search-bx mx-5">
                                    <div class="input-group">
                                        <input type="search" id="search" class="form-control" name="search"
                                            @isset($sort_search) value="{{ $sort_search }}" @endisset
                                            placeholder="{{ trans('messages.Title') }}" aria-label="Search"
                                            aria-describedby="button-addon2">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-3">
                            <select name="notification_type" id="notification-type" class="select2 form-control">
                                <option value="all" {{ $notification_type ?? 'all' == 'all' ? 'selected' : '' }}>
                                    {{ trans('messages.All') }}</option>
                                <option value="topic" {{ $notification_type ?? '' == 'topic' ? 'selected' : '' }}>
                                    {{ trans('messages.Topic Notification') }}</option>
                                <option value="user" {{ $notification_type ?? '' == 'user' ? 'selected' : '' }}>
                                    {{ trans('messages.User Notification') }}</option>
                            </select>
                        </div>
                        <div class="col-3" style="position: relative">
                            <i class="fa fa-filter"
                                style="position: absolute;{{ App::getLocale() == 'ar' ? 'right' : 'left' }}:1em;font-size: 1.5em;line-height: 1.5em;color: #FFF"></i>
                            <input style="height: 2em;line-height: 1em;padding: 0em 2em" type="submit"
                                value="{{ trans('messages.Filter') }}" class="btn btn-primary">
                        </div>
                        <div class="col" style="text-align: end">
                            <a href="{{ route('notification.create') }}"
                                class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                    class="mdi mdi-plus"><span class="path1"></span><span class="path2"></span></span></a>
                        </div>
                    </div>
                </form>
            </div>
            <div class="box-body no-padding">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr class="">
                                <th class="text-center">
                                    #
                                </th>
                                <th class="text-center">{{ trans('messages.Title') }}</th>
                                <th class="text-center">{{ trans('messages.Body') }}</th>
                                <th class="text-center">{{ trans('messages.Action') }}</th>
                                <th class="text-center">{{ trans('messages.topic') }}</th>
                                <th class="text-center">{{ trans('messages.user') }}</th>
                                <th class="text-center">{{ trans('messages.created_at') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($notifications as $key => $notification)
                                <tr>
                                    <td class="text-center">
                                        {{ $key + 1 + ($notifications->currentPage() - 1) * $notifications->perPage() }}
                                    </td>
                                    <td class="text-center">{{ $notification->title }}</td>
                                    <td class="text-center">{{ $notification->body }}</td>
                                    <td class="text-center">{{ $notification->action }}</td>
                                    <td class="text-center">
                                        <span class="badge bg-primary">
                                            {{ $notification->topic ? trans('messages.All subscribers of') . ' ' . $notification->topic : trans('messages.User Notification') }}
                                        </span>
                                    </td>
                                    <td class="text-center">
                                        <span class="badge bg-primary">
                                            {{ $notification->user->name ?? trans('messages.Topic Notification') }}
                                        </span>
                                    </td>
                                    <td class="text-center">{{ $notification->created_at }}</td>
                                </tr>
                            @endforeach

                        </tbody>
                    </table>
                    {!! $notifications->withQueryString()->links('pagination::bootstrap-4') !!}

                </div>
            </div>
        </div>
    </section>
@endsection
