<style>
    .bootstrap-tagsinput {
        width: 100%;
        padding: 0.6em;
    }
</style>
<!-- Main content -->
{!! Form::open([
    'method' => 'PUT',
    'route' => ['answer.update', $answer->id],
    'files' => true,
    'id' => 'edit-answer-form',
]) !!}
<!-- Nav tabs -->
<ul class="nav nav-tabs customtab2" role="tablist">
    <li class="nav-item"> <a class="nav-link active" data-toggle="tab" href="#home7" role="tab"><span
                class="hidden-sm-up"><i class="ion-home"></i></span> <span
                class="hidden-xs-down">{{ trans('messages.Arabic') }}</span></a> </li>
    <li class="nav-item"> <a class="nav-link" data-toggle="tab" href="#profile7" role="tab"><span
                class="hidden-sm-up"><i class="ion-person"></i></span> <span
                class="hidden-xs-down">{{ trans('messages.Netherland') }}</span></a> </li>
    <li class="nav-item"> <a class="nav-link" data-toggle="tab" href="#home8" role="tab"><span
                class="hidden-sm-up"><i class="ion-home"></i></span> <span
                class="hidden-xs-down">{{ trans('messages.English') }}</span></a> </li>
</ul>

<!-- Tab panes -->
<div class="tab-content">
    <div class="tab-pane active" id="home7" role="tabpanel">
        <div class="p-15">
            <div class="form-group">
                <label for="answer_ar">{{ trans('messages.Answer Ar') }}
                </label>
                <div>
                    {!! Form::number('answer_ar', $answer->answer_ar, [
                        'class' => 'form-control',
                        'placeholder' => trans('messages.Answer Ar'),
                    ]) !!}
                </div>
                @error('answer_ar')
                    <div class="badge badge-danger text-center" style="width: 100%">
                        {{ $message }}
                    </div>
                @enderror
            </div>
        </div>
    </div>
    <div class="tab-pane" id="home8" role="tabpanel">
        <div class="p-15">
            <div class="form-group">
                <label for="answer_en">{{ trans('messages.Answer EN') }}
                </label>
                <div>
                    {!! Form::number('answer_en', $answer->answer_en, [
                        'class' => 'form-control',
                        'placeholder' => trans('messages.Answer EN'),
                    ]) !!}
                </div>
                @error('answer_en')
                    <div class="badge badge-danger text-center" style="width: 100%">
                        {{ $message }}
                    </div>
                @enderror
            </div>
        </div>
    </div>
    <div class="tab-pane" id="profile7" role="tabpanel">
        <div class="p-15">
            <div class="form-group">
                <label for="answer_nl">{{ trans('messages.Answer Nl') }}
                </label>
                <div>
                    {!! Form::number('answer_nl', $answer->answer_nl, [
                        'class' => 'form-control',
                        'placeholder' => trans('messages.Answer Nl'),
                    ]) !!}
                </div>
                @error('answer_nl')
                    <div class="badge badge-danger text-center" style="width: 100%">
                        {{ $message }}
                    </div>
                @enderror
            </div>
        </div>
    </div>
    <div class="form-group">
        <h2 class="panel-title">{{ trans('messages.Add country') }}</h2>
        @foreach ($countries as $country)
            @php
                $columnName = 'country_' . $country->code;
                $isChecked = $answer->$columnName ? 'checked' : '';
            @endphp
            <div class="checkbox">
                <input type="checkbox" name="country_{{ $country->code }}" id="Checkbox_{{ $country->code }}"
                    value="1" {{ $isChecked }} />
                <label for="Checkbox_{{ $country->code }}">{{ $country->name . '~' . $country->code }}</label>
            </div>
        @endforeach
    </div>
</div>
<button type="submit" class="btn btn-rounded btn-primary btn-outline">
    <i class="ti-save-alt"></i> {{ trans('messages.Save') }}
</button>

{!! Form::Close() !!}
<script type="text/javascript">
    $('#edit-answer-form').on('submit', function(e) {
        e.preventDefault();

        var formData = $(this).serializeArray();

        formData.push({
            name: 'question_id',
            value: {{ $answer->question->id }}
        });
        formData.push({
            name: 'redirect_head',
            value: 'ajax_create'
        });
        formData.push({
            name: 'redirect_body',
            value: {{ $redirectArr[0]['value'] }}
        });

        var formDataObject = {};
        $.each(formData, function(i, field) {
            if (field.name.startsWith('country_')) {
                formDataObject[field.name] = field.value || '0';
            } else {
                formDataObject[field.name] = field.value;
            }
        });

        $.ajax({
            url: $(this).attr('action'),
            type: 'PUT',
            data: formDataObject,
            success: function(data) {
                $("#exam-categories-section").html(data);
                $('#create-with-ajax').modal('hide');
            },
            error: function(xhr) {
                var errors = $.parseJSON(xhr.responseText);
                $.each(errors, function(key, value) {
                    if ($.isPlainObject(value)) {
                        $.each(value, function(k, v) {
                            $('#' + key + '-error').show().html(v);
                        });
                    } else {
                        // Handle general error case
                        console.error(value);
                    }
                });
            }
        });
    });
</script>
