@extends('site.layouts.main')
@section('meta_title')
    {{ trans('messages.Adnan Eltaher') . ' | ' . trans('messages.Theory Packages') }}
@stop
@section('content')

<style>
    .video_header {
        background-color:#1BA9FF1A;
        padding: 2rem 1.5rem;
        margin-block: 2rem 2.5rem;
    }
    .video_header .video iframe{
        border-radius: 10px;
        overflow:hidden;
    }
    .video_header .video_info .video_title {
        font-size: 24px;
        color:#0E5078;
        margin-bottom:1.3rem;
    }
    .video_header .video_info .video_desc {
        font-size: 20px;
        color:#535353;
        font-weight:400;
        line-height: 1.1;
    }
    .video_header .video_info .video_data {
        margin-top: 1.5rem
    }
    .video_header .video_info .video_data .data_wrapper{
        margin-bottom: 1rem
    }
    .video_header .video_info .video_data .data_wrapper .text{
        margin-inline-start: 0.5rem
    }
    .video_header .video_info .video_data .data_wrapper .icon{
        color:#1BA9FF;
    }

    /*  list styles */
    .course_details {
        padding-inline: 1.5rem;
    }
    .course_details .tabs_wrapper .nav .nav-item{
        margin-inline-end: 1.2rem;
        box-shadow: 0px 2px 4px -2px #0A0D120F;
    }
    .course_details .tabs_wrapper .nav .nav-item .nav-link{
        color: #A7A7A7;
        border: 0.3px solid #A7A7A7;
        font-weight: 400;
    }
    .course_details .tabs_wrapper .nav .nav-item .nav-link.active{
        background: #1BA9FF;
        color: #fff;
        border: unset;
    }
    .course_details .tab-content {
        margin-block: 2rem 3rem;
    }
    .course_details .course_content_list , .course_details .selected_course{
        height: 500px
    }
    .course_details .course_content_list {
        overflow: hidden scroll;
        border: 1px solid #E4E4E4;
        border-radius: 7px
    }
    .course_details .course_content_list .list_card {
        padding: 0.5rem 0.8rem;
        border-bottom: 1px solid #E4E4E4;
        cursor: pointer;
    }
    .course_details .course_content_list .list_card.active{
        position: relative;
    }
    .course_details .course_content_list .list_card.active::before{
        content: "";
        position:absolute;
        right: 0;
        top:10%;
        bottom:10%;
        width: 3px;
        background: #124E72;
        height: 80%;
    }
    .course_details .course_content_list .list_card.active::after {
        content: "";
        position: absolute;
        right: 0px;
        top: 50%;
        transform: translateY(-50%);
        border-width: 6px;
        border-style: solid;
        border-color: transparent #124E72 transparent transparent;
        width: 0;
        height: 0;
    }
    .course_details .course_content_list .list_card .card_text .title{
        font-size:17px;
        color: #0E5078;
        margin-bottom: 0.5rem;
    }
    .course_details .course_content_list .list_card .card_text .desc{
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;  
        overflow: hidden;
        font-size: 15px;
        color:#888686;
        width: 90%;
    }
    .course_details .course_content_list .list_card .card_img img{
        width: 130px;
        height: 100px;
    }
    .course_details .selected_course iframe {
        border-radius: 10px;
        overflow:hidden;
    }


</style>

<div class="video_details">
    <div class="video_header">
        <div class="row">
            <div class="col-lg-6">
                <div class="video">
                    <iframe width="90%" height="315" src="https://www.youtube.com/embed/1NEMvybTarc?si=8ZyBZzNotxLfKT9C" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="video_info">
                    <h2 class="video_title">
                        تعلم قيادة السيارات - دورة المستوى المبتدئ
                    </h2>
                    <p class="video_desc">
                        بدأ رحلتك نحو قيادة آمنة وواثقة مع دورة المستوى المبتدئ. تركز هذه الدورة على الجوانب النظرية والعملية للقيادة، حيث ستتعلم قواعد المرور، أساسيات التحكم بالمركبة، وتقنيات القيادة الآمنة. بقيادة مدربين معتمدين، تعتبر هذه الدورة الخطوة المثالية للراغبين في تعلم القيادة من البداية. سجل الآن وانطلق نحو طريقك بثقة! 🚦
                    </p>
                    <div class="video_data">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="data_wrapper d-flex align-items-center">
                                    <span class="icon">
                                        <i class="fas fa-calendar-alt"></i>
                                    </span>
                                    <span class="text">
                                        المدة: أسبوعان
                                    </span>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="data_wrapper d-flex align-items-center">
                                    <span class="icon">
                                    <i class="fas fa-hourglass-half"></i>
                                    </span>
                                    <span class="text">
                                        عدد تكرار الفيديو: 40
                                    </span>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="data_wrapper d-flex align-items-center">
                                    <span class="icon">
                                        <i class="fas fa-eye"></i>
                                    </span>
                                    <span class="text">
                                        عدد تكرار المشاهدة: 50
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="course_details">
        <nav class="tabs_wrapper">
            <div class="nav nav-bills" id="nav-tab" role="tablist">
                <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="pills-home-tab" data-bs-toggle="pill" data-bs-target="#pills-home" type="button" role="tab" aria-controls="pills-home" aria-selected="true">
                            محتوي الدورة
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="pills-profile-tab" data-bs-toggle="pill" data-bs-target="#pills-profile" type="button" role="tab" aria-controls="pills-profile" aria-selected="false">
                            وصف الدورة
                        </button>
                    </li>
                </ul>
            </div>
        </nav>
        <div class="tab-content" id="pills-tabContent">
            <div class="tab-pane fade show active" id="pills-home" role="tabpanel" aria-labelledby="pills-home-tab">
                <div class="course_content">
                    <div class="row">
                        <div class="col-md-6 col-lg-4">
                            <div class="course_content_list">
                                <div class="list_card active d-flex align-items-center justify-content-between">
                                    <div class="card_text">
                                        <h4 class="title">
                                            الدرس الأول 
                                        </h4>
                                        <span class="desc">
                                            يقوم بتدريبك مدربون معتمدون ذوو خبرة عالية، مما يجعل هذه الدورة..... 
                                        </span>
                                    </div>
                                    <div class="card_img">
                                        <img 
                                            src="http://192.168.1.65/newTaher/public/front_them/assets/imgs/reserve-img.png"
                                            alt="">
                                    </div>
                                </div>
                                <div class="list_card d-flex align-items-center justify-content-between">
                                    <div class="card_text">
                                        <h4 class="title">
                                            الدرس الأول 
                                        </h4>
                                        <span class="desc">
                                            يقوم بتدريبك مدربون معتمدون ذوو خبرة عالية، مما يجعل هذه الدورة..... 
                                        </span>
                                    </div>
                                    <div class="card_img">
                                        <img 
                                            src="http://192.168.1.65/newTaher/public/front_them/assets/imgs/reserve-img.png"
                                            alt="">
                                    </div>
                                </div>
                                <div class="list_card d-flex align-items-center justify-content-between">
                                    <div class="card_text">
                                        <h4 class="title">
                                            الدرس الأول 
                                        </h4>
                                        <span class="desc">
                                            يقوم بتدريبك مدربون معتمدون ذوو خبرة عالية، مما يجعل هذه الدورة..... 
                                        </span>
                                    </div>
                                    <div class="card_img">
                                        <img 
                                            src="http://192.168.1.65/newTaher/public/front_them/assets/imgs/reserve-img.png"
                                            alt="">
                                    </div>
                                </div>
                                <div class="list_card d-flex align-items-center justify-content-between">
                                    <div class="card_text">
                                        <h4 class="title">
                                            الدرس الأول 
                                        </h4>
                                        <span class="desc">
                                            يقوم بتدريبك مدربون معتمدون ذوو خبرة عالية، مما يجعل هذه الدورة..... 
                                        </span>
                                    </div>
                                    <div class="card_img">
                                        <img 
                                            src="http://192.168.1.65/newTaher/public/front_them/assets/imgs/reserve-img.png"
                                            alt="">
                                    </div>
                                </div>
                                <div class="list_card d-flex align-items-center justify-content-between">
                                    <div class="card_text">
                                        <h4 class="title">
                                            الدرس الأول 
                                        </h4>
                                        <span class="desc">
                                            يقوم بتدريبك مدربون معتمدون ذوو خبرة عالية، مما يجعل هذه الدورة..... 
                                        </span>
                                    </div>
                                    <div class="card_img">
                                        <img 
                                            src="http://192.168.1.65/newTaher/public/front_them/assets/imgs/reserve-img.png"
                                            alt="">
                                    </div>
                                </div>
                                <div class="list_card d-flex align-items-center justify-content-between">
                                    <div class="card_text">
                                        <h4 class="title">
                                            الدرس الأول 
                                        </h4>
                                        <span class="desc">
                                            يقوم بتدريبك مدربون معتمدون ذوو خبرة عالية، مما يجعل هذه الدورة..... 
                                        </span>
                                    </div>
                                    <div class="card_img">
                                        <img 
                                            src="http://192.168.1.65/newTaher/public/front_them/assets/imgs/reserve-img.png"
                                            alt="">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-8">
                            <div class="selected_course">
                                <iframe width="100%" height="500" src="https://www.youtube.com/embed/1NEMvybTarc?si=8ZyBZzNotxLfKT9C" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade" id="pills-profile" role="tabpanel" aria-labelledby="pills-profile-tab">
                هل أنت مستعد للانطلاق في رحلتك لتعلم القيادة؟ توفر لك دورة تعليم قيادة السيارات للمستوى المبتدئ كل ما تحتاجه لبناء الثقة وإتقان المهارات الأساسية للقيادة الآمنة والمسؤولة. تركز هذه الدورة على الجوانب النظرية والعملية، حيث ستتعلم قواعد المرور الأساسية، وتقنيات التحكم بالمركبة، وأهم قوانين السلامة المرورية. يقوم بتدريبك مدربون معتمدون ذوو خبرة عالية، مما يجعل هذه الدورة الخيار الأمثل للمبتدئين الراغبين في تعلم القيادة من الصفر. بنهاية الدورة، ستكون قادرًا على التعامل بثقة مع مختلف مواقف القيادة على الطريق.
            </div>
        </div>
    </div>
</div>


@endsection
@section('script')
        <script>
            
        </script>
@endsection
