<style>
    .bootstrap-tagsinput {
        width: 100%;
        padding: 0.6em;
    }
</style>
<!-- Main content -->

{!! Form::open(['route' => 'answer.store', 'files' => true, 'id' => 'add-answer-form']) !!}
{!! Form::hidden('question_id', $question->id, []) !!}
{!! Form::hidden('redirect_head', 'ajax_create', []) !!}
{!! Form::hidden('redirect_body', sizeof($redirectArr) > 0 ? $redirectArr[0]['value'] : null, []) !!}
<div class="form-group row">
    <div class="col-lg-8 mx-auto">
        <div class="custom-file-container">
            <div class="custom-file">
                <input type="file" name="answer_image" class="custom-file-input" id="answer_image">
                <label class="custom-file-label" for="answer_image">{{ trans('messages.Image') }}</label>
            </div>
            <div class="bg-lightest p-10 rounded5 dvPreview text-center"
                style="width: 100%;margin-top: 1em;height: 10em;">
                <img style="max-width: 100%;height: 100%;" src="{{ url('/images/noimg.png') }}" alt="">
            </div>
        </div>
        @error('answer_image')
            <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
            </div>
        @enderror
    </div>

</div>
<div class="form-group">
    <label for="arrangment">{{ trans('messages.Arrangment') }}
    </label>
    <div>
        {!! Form::number('arrangment', null, [
            'class' => 'form-control',
            'placeholder' => trans('messages.Arrangment'),
        ]) !!}
    </div>
    @error('arrangment')
        <div class="badge badge-danger text-center" style="width: 100%">
            {{ $message }}
        </div>
    @enderror
</div>
<div class="form-group">
    <div class="checkbox">
        {!! Form::checkbox('right_answer', null, 1, ['id' => 'right_answer']) !!}
        <label for="right_answer">{{ trans('messages.Right answer') }}</label>
    </div>
</div>
<div class="form-group">
    <h2 class="panel-title">{{ trans('messages.Add country') }}</h2>
    @foreach ($countries as $country)
        <div class="checkbox">
            <input type="checkbox" name="country_{{ $country->code }}" id="Checkbox_{{ $country->code }}" value="1"
                {{ old('country_' . $country->code) ? 'checked' : '' }} />
            <label for="Checkbox_{{ $country->code }}">{{ $country->name . '~' . $country->code }}</label>
        </div>
    @endforeach
</div>

<button type="submit" class="btn btn-rounded btn-primary btn-outline">
    <i class="ti-save-alt"></i> {{ trans('messages.Save') }}
</button>

{!! Form::Close() !!}

<script type="text/javascript">
    $(".custom-file-input").change(function() {
        var img_src = jQuery(this).parents('.custom-file').parents('.custom-file-container').find("img");
        var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.jpg|.jpeg|.gif|.png|.bmp)$/;
        if (regex.test($(this).val().toLowerCase())) {
            if (typeof(FileReader) != "undefined") {
                var reader = new FileReader();
                reader.onload = function(e) {
                    img_src.attr("src", e.target.result);
                    $('.custem-css-templet img').attr('src', e.target.result);
                }
                reader.readAsDataURL($(this)[0].files[0]);
            } else {
                alert("This browser does not support FileReader.");
            }
        } else {
            alert("Please upload a valid image file.");
        }
    });

    $('#add-answer-form').on('submit', function(e) {
        e.preventDefault();
        var formData = new FormData(this);
        @foreach ($countries as $country)
            formData.delete('country_{{ $country->code }}');
            if ($("#Checkbox_{{ $country->code }}").is(":checked")) {
                formData.append('country_{{ $country->code }}', '1');
            }
        @endforeach

        $.ajax({
            url: $(this).attr('action'),
            type: "POST",
            data: formData,
            success: function(msg) {
                $("#exam-categories-section").html(msg);
                $('#create-with-ajax').modal('hide');
            },
            error: function(xhr) {
                var errors = $.parseJSON(xhr.responseText);
                $.each(errors, function(key, value) {
                    if ($.isPlainObject(value)) {
                        $.each(value, function(k, v) {
                            $('#' + key + '-error').show().html(v);
                        });
                    }
                });
            },
            cache: false,
            contentType: false,
            processData: false
        });
    });
</script>
