<?php

namespace App\Sys\Services\General;

use App\Sys\Services;
use App\Mail\ContactUs;
use App\Models\Setting;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use App\Sys\Repositories\General\CommunicationMethodRepository;

class CommunicationService extends Services
{
    protected $communicationMethodRepository;

    public function __construct(CommunicationMethodRepository $communicationMethodRepository)
    {
        $this->communicationMethodRepository = $communicationMethodRepository;
    }
    public function getAllMethods()
    {
        $communications = $this->communicationMethodRepository->getAllMethods();

        if (!$communications) {
            return false;
        }

        return [
            'socialMedia' => [
                'facebook' => $communications->facebook,
                'youtube' => $communications->youyube,
                'whatsapp' => $communications->whatsapp,
                'twitter' => $communications->tweeter
            ],
            'contact' => [
                'main_phone' => $communications->main_phone,
                'secondary_phone' => $communications->secoundry_phone,
                'email' => $communications->email,
                'address' => $communications->address,
            ],
        ];
    }

    public function handleContactFormSubmission($user, $data)
    {
        $rules = [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'email', 'max:255'],
            'message' => ['required', 'string', 'min:3', 'max:1000'],
        ];

        $validator = Validator::make($data, $rules);

        if ($validator->fails()) {
            $this->setError($validator->errors());
            return false;
        }

        Mail::to(Setting::find(1)->email)->send(new ContactUs($data));

        return true;
    }
}
