<?php

namespace App\Sys\Repositories\Blogs;

use App\Models\Blog;

class BlogRepository
{
    public function getPaginatedBlogs($limit)
    {
        $country = config('app.country');

        return Blog::query()
            ->where('country_' . $country, true)
            ->latest()
            ->paginate($limit);
    }

    public function getPaginatedBlogsByCategoryId($categoryId, $limit)
    {
        $country = config('app.country');

        return Blog::query()
            ->where('country_' . $country, true)
            ->where('blog_category_id', $categoryId)
            ->latest()
            ->paginate($limit);
    }

    public function getSelectedBlog($blogId)
    {
        $country = config('app.country');

        return Blog::query()
            ->where('country_' . $country, true)
            ->find($blogId);
    }
}
