<?php

namespace App\Models;

use App\Traits\HasCountryTags;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\App;

class Videos extends Model
{
    use softDeletes, HasCountryTags;
    protected $table = 'video';
    protected $appends = [
        'country_ia',
        'country_sa',
        'country_ae',
        'url',
        'name',
        'desc',
        'photo'
    ];

    public function getUrlAttribute()
    {
        return $this->{'url_' . App::getLocale()} == null ? $this->name_ar : $this->{'url_' . App::getLocale()};
    }
    public function getNameAttribute()
    {
        return $this->{'name_' . App::getLocale()} == null ? $this->name_ar : $this->{'name_' . App::getLocale()};
    }
    public function getDescAttribute()
    {
        return $this->{'desc_' . App::getLocale()} == null ? $this->name_ar : $this->{'desc_' . App::getLocale()};
    }
    public function getPhotoAttribute()
    {
        return $this->image != null && file_exists(public_path() . '/' . $this->image) ? url('/' . $this->image) : null;
    }
    public function packageVideo()
    {
        return $this->belongsToMany(PackageVideo::class, 'package_video_video', 'video_id', 'package_id');
    }
    public function videoShows()
    {
        return $this->hasMany(PackageVideoUserWatch::class, 'video_id');
    }
}
