<?php

namespace App\Models;

use App\Traits\HasCountryTags;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\App;

class TheoryPackage extends Model
{
    use HasFactory, HasCountryTags;
    protected $appends = [
        'name',
        'shortDesc',
        'notes',
        'photo',
        'picture',
        'coverPhone',
        'coverDesktop',
    ];

    public function getNameAttribute()
    {
        return $this->{'name_' . App::getLocale()} == null ? $this->name_ar : $this->{'name_' . App::getLocale()};
    }
    public function getShortDescAttribute()
    {
        return $this->{'short_desc_' . App::getLocale()} == null ? $this->name_ar : $this->{'short_desc_' . App::getLocale()};
    }
    public function getNotesAttribute()
    {
        return $this->{'notes_' . App::getLocale()} == null ? $this->name_ar : $this->{'notes_' . App::getLocale()};
    }
    public function getPhotoAttribute()
    {
        return $this->photo_phone != null && file_exists(public_path() . '/' . $this->photo_phone) ? url('/' . $this->photo_phone) : null;
    }
    public function getPictureAttribute()
    {
        return $this->image != null && file_exists(public_path() . '/' . $this->image) ? url('/' . $this->image) : null;
    }
    public function getCoverPhoneAttribute()
    {
        return $this->{'cove_phone_' . App::getLocale()} != null && file_exists(public_path() . '/' . $this->{'cove_phone_' . App::getLocale()})
            ? url('/' . $this->{'cove_phone_' . App::getLocale()})
            : null;
    }
    public function getCoverDesktopAttribute()
    {
        return $this->{'cove_desktop_' . App::getLocale()} != null && file_exists(public_path() . '/' . $this->{'cove_desktop_' . App::getLocale()})
            ? url('/' . $this->{'cove_desktop_' . App::getLocale()})
            : null;
    }
    protected $fillable = [
        'country_ia',
        'country_sa',
        'country_ae',
        'image',
        'name_ar',
        'name_en',
        'name_nl',
        'short_desc_ar',
        'short_desc_en',
        'short_desc_nl',
        'notes_ar',
        'notes_en',
        'notes_nl',
        'show_in_home',
        'arrangement',
        'price',
        'expiration_duration_in_dayes',
        'enable',
    ];

    public function subscriptions()
    {
        return $this->hasMany(TheorySubscription::class, 'theory_package_id')
            ->whereIn('pay_type', ['cash', 'visa', 'processing']);
    }
}
