<?php

namespace App\Models;

use App\Traits\HasCountryTags;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Subscription extends Model
{
    use HasFactory, HasCountryTags;

    protected $fillable = [
        'country_ia',
        'country_sa',
        'country_ae',
        'package_id',
        'offer_id',
        'offer_discount',
        'price',
        'user_id',
        'subscription_date',
        'expiration_date',
        'renewed_times',
        'pay_type'
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function package()
    {
        return $this->belongsTo(Package::class, 'package_id');
    }
}
