<?php

namespace App\Models;

use App\Traits\HasCountryTags;
use Illuminate\Support\Facades\App;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Question extends Model
{
    use HasFactory, HasCountryTags;

    protected $fillable = [
        'country_ia',
        'country_sa',
        'country_ae',
        'question_ar',
        'question_en',
        'question_nl',
        'exam_category_id',
        'exam_id',
        'question_type',
        'question_image',
        'question_uuid',
        'arrangment',
        'answer_explanation_ar',
        'answer_explanation_en',
        'answer_explanation_nl',
    ];
    protected $appends = ['question', 'answerExplanation', 'photo'];

    public function getQuestionAttribute()
    {
        return $this->{'question_' . App::getLocale()} == null ? $this->question_ar : $this->{'question_' . App::getLocale()};
    }
    public function getAnswerExplanationAttribute()
    {
        return $this->{'answer_explanation_' . App::getLocale()} == null ? $this->answer_explanation_ar : $this->{'answer_explanation_' . App::getLocale()};
    }
    public function getPhotoAttribute()
    {
        return ($this->question_image != null && file_exists(public_path() . '/' . $this->question_image)) ? url('/' . $this->question_image) : null;
    }

    public function answers()
    {
        return $this->hasMany(Answer::class, 'question_id')->orderBy('arrangment', 'asc');
    }

    public function exam()
    {
        return $this->belongsTo(Exam::class, 'exam_id');
    }

    public function examCategory()
    {
        return $this->belongsTo(ExamCategory::class, 'exam_category_id');
    }

    public function favoritedBy()
    {
        return $this->belongsToMany(User::class, 'favorite_questions', 'question_id', 'user_id');
    }
}
