<?php

namespace App\Models;

use App\Traits\HasCountryTags;
use Illuminate\Support\Facades\App;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Page extends Model
{
    use HasFactory, HasCountryTags;

    protected $appends = ['body', 'slug', 'title', 'tags'];

    public function getBodyAttribute()
    {
        return $this->{'body_' . App::getLocale()} == null ? $this->body_ar : $this->{'body_' . App::getLocale()};
    }
    public function getSlugAttribute()
    {
        return $this->{'slug_' . App::getLocale()} == null ? $this->slug_ar : $this->{'slug_' . App::getLocale()};
    }
    public function getTitleAttribute()
    {
        return $this->{'title_' . App::getLocale()} == null ? $this->title_ar : $this->{'title_' . App::getLocale()};
    }
    public function getTagsAttribute()
    {
        return $this->{'tags_' . App::getLocale()} == null ? $this->tags_ar : $this->{'tags_' . App::getLocale()};
    }
    protected $fillable = [
        'title_ar',
        'title_en',
        'title_nl',
        'slug_ar',
        'slug_en',
        'slug_nl',
        'body_ar',
        'body_en',
        'body_nl',
        'tags_ar',
        'tags_en',
        'tags_nl',
        'enabel'
    ];
}
