<?php

namespace App\Models;

use App\Traits\HasCountryTags;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\App;

class Package extends Model
{
    use HasFactory, HasCountryTags;
    protected $appends = ['name', 'notes', 'badge', 'photo', 'coverPhone'];

    public function getNameAttribute()
    {
        return $this->{'name_' . App::getLocale()} == null ? $this->name_ar : $this->{'name_' . App::getLocale()};
    }
    public function getNotesAttribute()
    {
        return $this->{'notes_' . App::getLocale()} == null ? $this->notes_ar : $this->{'notes_' . App::getLocale()};
    }
    public function getBadgeAttribute()
    {
        return $this->{'badge_' . App::getLocale()} == null ? $this->badge_ar : $this->{'badge_' . App::getLocale()};
    }
    public function getPhotoAttribute()
    {
        return $this->photo_phone != null && file_exists(public_path() . '/' . $this->photo_phone) ? url('/' . $this->photo_phone) : null;
    }
    public function getCoverPhoneAttribute()
    {
        return $this->{'cove_phone_' . App::getLocale()} != null && file_exists(public_path() . '/' . $this->{'cove_phone_' . App::getLocale()}) ? url('/' . $this->{'cove_phone_' . App::getLocale()}) : null;
    }

    protected $fillable = [
        'country_ia',
        'country_sa',
        'country_ae',
        'name_ar',
        'name_en',
        'name_nl',
        'notes_ar',
        'notes_en',
        'notes_nl',
        'badge_ar',
        'badge_en',
        'badge_nl',
        'show_in_home',
        'arrangement',
        'exam_count',
        'price',
        'expiration_duration_in_dayes',
        'photo_phone',
        'photo_desktop',
        'color_background',
        'color_border',
        "cove_desktop_en",
        "cove_desktop_nl",
        "cove_desktop_ar",
        "cove_phone_ar",
        "cove_phone_en",
        "cove_phone_nl",
    ];

    public function offer()
    {
        return $this->hasOne(Offer::class, 'package_id')->where('end_date', '>', Carbon::now());
    }

    public function exams()
    {
        return $this->belongsToMany(Exam::class, 'package_exams', 'package_id', 'exam_id');
    }

    public function results()
    {
        return $this->hasMany(Result::class, 'package_id');
    }

    public function subscriptions()
    {
        return $this->hasMany(Subscription::class, 'package_id');
    }
}
