<?php

namespace App\Models;

use Illuminate\Support\Facades\App;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Country extends Model
{
    use HasFactory;

    protected $appends = ['name'];

    protected $fillable = [
        'name_ar',
        'name_en',
        'name_nl',
        'code',
    ];

    public function getNameAttribute()
    {
        return $this->{'name_' . App::getLocale()} == null ? $this->name_ar : $this->{'name_' . App::getLocale()};
    }

    public function users()
    {
        return $this->hasMany(User::class, 'language_id');
    }

    public static function getAvailableCountries()
    {
        return [
            'sa' => 'Saudi Arabia',
            'ae' => 'United Arab Emirates',
            'ia' => 'Iraq'
        ];
    }
}
