<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class PageResource extends JsonResource
{
    protected $language;

    public function __construct($resource, $language = 'ar')
    {
        parent::__construct($resource);
        $this->language = $language;
    }

    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'slug' => $this->getTranslatedField('slug'),
            'title' => $this->getTranslatedField('title'),
            'tags' => $this->getTranslatedField('tags'),
            'body' => $this->getTranslatedField('body'),
            'enabel' => $this->enabel,
            'photo_phone' => $this->photo_phone,
            'photo_extension' => $this->checkExtions($this->photo_phone),
            'color_background' => $this->color_background,
            'color_border' => $this->color_border,
        ];
    }

    protected function getTranslatedField($field)
    {
        $translatedField = $field . '_' . $this->language;

        return $this->resource->$translatedField;
    }

    public function checkExtions($pro)
    {
        if ($pro != null) {
            $extension = pathinfo($pro, PATHINFO_EXTENSION);
            $imageExtensions = ['jpg', 'jpeg', 'png', 'gif', 'webp', 'bmp'];
            if (in_array(strtolower($extension), $imageExtensions)) {
                return 'photo';
            }

            return 'video';
        }

        return null;
    }
}
