<?php

namespace App\Http\Resources;

use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class PackageVideoResource extends JsonResource
{

    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'notes' => $this->notes,
            'badge' => $this->badge,
            "show_in_home" => $this->show_in_home,
            "video_count" => $this->video_count,
            "allowed_views_per_video" => $this->show_one_video,
            "price" => $this->price,
            "expiration_duration_in_days" => $this->expiration_duration_in_dayes,
            "total_videos_views_permitted" => $this->count_play_video,
            'phonePhoto' => $this->phonePhoto,
            'phonePhoto_extension' => $this->checkExtions($this->phonePhoto),
            'color_background' => $this->color_background,
            'color_border' => $this->color_border,
            'active' => $this->active,
            'type_view' => $this->type_view,
            'coverDesktop' => $this->coverDesktop,
            'coverDesktop_extension' => $this->checkExtions($this->coverDesktop),
            'offer' => $this->getOfferData(),
            'video' => $this->whenLoaded('video', function () {
                return VideoResource::collection($this->video);
            }, null),
        ];
    }

    public function checkExtions($pro)
    {
        if ($pro != null) {
            $extension = pathinfo($pro, PATHINFO_EXTENSION);
            $imageExtensions = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
            if (in_array(pathinfo($pro, PATHINFO_EXTENSION), ["jpg", "jpeg", "gif", "png", "bmp", "webp", "PNG", "GIF", "JPG"]))
                return 'photo';

            return 'video';
        }

        return null;
    }

    public function getOfferData()
    {
        if ($this->offer != null) {
            return [
                'id' => $this->offer->id,
                'name' => $this->offer->title,
                'start_date' => Carbon::parse($this->offer->start_date)->format('Y-m-d H:i:s'),
                'end_date' => Carbon::parse($this->offer->end_date)->format('Y-m-d H:i:s'),
                'discount_amount' => $this->offer->discount_amount,
            ];
        }

        return null;
    }
}
