<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\ResourceCollection;

class NotificationCollection extends ResourceCollection
{
    public function toArray($request)
    {
        $grouped = $this->collection->groupBy(function ($item) {
            return $item->created_at->format('M d');
        });

        $groupedNotifications = $grouped->map(function ($notifications, $date) {
            return [
                'Formated_date' => $date,
                'notifications' => NotificationResource::collection($notifications)
            ];
        })->values();

        return [
            'data' => $groupedNotifications,
            'links' => $this->paginationLinks(),
            'meta' => [
                'pagination' => [
                    'total' => $this->total(),
                    'count' => $this->count(),
                    'per_page' => $this->perPage(),
                    'current_page' => $this->currentPage(),
                    'total_pages' => $this->lastPage(),
                ],
            ],
        ];
    }

    protected function paginationLinks()
    {
        $paginator = $this->resource;


        $prevPage = $paginator->currentPage() - 1;
        $nextPage = $paginator->currentPage() + 1;


        $links =  $nextPage <= $paginator->lastPage() ? $paginator->url($nextPage) : null;

        return $links;
    }
}
