<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class BlogResource extends JsonResource
{

    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'blog_category_id' => $this->blog_category_id,
            'title' => $this->title,
            'slug' => $this->slug,
            'description' => $this->description,
            'body' => $this->body,
            'tags' => $this->tags,
            'photo' => $this->photo,
            'photo_extension' => $this->checkExtions($this->photo),
            'created_at' => $this->created_at,
        ];
    }

    public function checkExtions($pro)
    {
        if ($pro != null) {
            $extension = pathinfo($pro, PATHINFO_EXTENSION);
            $imageExtensions = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
            if (in_array(pathinfo($pro, PATHINFO_EXTENSION), ["jpg", "jpeg", "gif", "png", "bmp", "webp", "PNG", "GIF", "JPG"]))
                return 'photo';

            return 'video';
        }

        return null;
    }
}
