<?php

namespace App\Http\Requests;

use App\Models\Country;
use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class UpdatePackageVideoSubscriptionRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $countries = Country::pluck('code')->toArray();
        $countryRules = [];

        foreach ($countries as $code) {
            $countryRules['country_' . $code] = ['nullable', 'boolean'];
        }

        return array_merge([
            'package_id' => ['required', 'exists:package_video,id'],
            'offer_id' => [
                'nullable',
                Rule::exists('package_video_offers', 'id')->where(function ($query) {
                    return $query->where('package_id', $this->package_id);
                }),
            ],
            'price' => ['required', 'numeric', 'min:0'],
            'subscription_date' => ['required', 'date', 'before_or_equal:expiration_date'],
            'expiration_date' => ['required', 'date', 'after_or_equal:subscription_date'],
        ], $countryRules);
    }
}
