<?php

namespace App\Http\Controllers\Api\Notifications;

use App\ApiResponse;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Http\Resources\NotificationCollection;
use App\Sys\Services\Notifications\UserNotificationService;

class NotificationController extends Controller
{
    use ApiResponse;
    private $userNotificationService;
    public function __construct(UserNotificationService $userNotificationService)
    {
        $this->userNotificationService = $userNotificationService;
    }
    public function userNotificationsIndex()
    {
        $user = Auth::guard('api')->user();

        $results = $this->userNotificationService->getUserNotifications($user);

        if (! $results) {
            return $this->apiResponse(400, 'fail', null, null);
        }

        $notifications = new NotificationCollection($results);

        return $this->apiResponse(200, 'All data', null, $notifications);
    }

    public function markAsRead(Request $request)
    {
        $user = Auth::guard('api')->user();

        $results = $this->userNotificationService->markNotificationAsRead($request, $user);

        if (! $results) {
            return $this->apiResponse(400, 'fail', null, null);
        }

        return $this->apiResponse(200, 'All data', null, null);
    }
}
