<?php

namespace App\Http\Controllers\Api\General;

use App\ApiResponse;
use App\Http\Controllers\Controller;
use App\Sys\Services\Packages\PackageVideoService;
use App\Sys\Services\Packages\SubscriptionService;
use Illuminate\Support\Facades\Auth;

class GeneralPackageControllers extends Controller
{
    use ApiResponse;

    protected $subscriptionService;

    protected $packageVideoService;

    public function __construct(
        SubscriptionService $subscriptionService,
        PackageVideoService $packageVideoService
    ) {
        $this->subscriptionService = $subscriptionService;
        $this->packageVideoService = $packageVideoService;
    }

    public function getSubscriptionDetails()
    {
        $user = Auth::guard('api')->user();

        $response = [
            'package_id' => null,
            'package_name' => null,
            'subscription_expiration_date' => null,
            'package_video_id' => null,
            'package_video_name' => null,
            'package_video_expiration_date' => null,
        ];

        $subscription = $this->subscriptionService->getLatestSubscriptionDetails($user);

        if ($subscription && $subscription->package) {
            $response['package_id'] = $subscription->package_id;
            $response['package_name'] = $subscription->package->name;
            $response['subscription_expiration_date'] = $subscription->expiration_date;
        }

        $packageVideo = $this->packageVideoService->getPackageVideoDetails($user);

        if ($packageVideo && $packageVideo->package) {
            $response['package_video_id'] = $packageVideo->id;
            $response['package_video_name'] = $packageVideo->package->name;
            $response['package_video_expiration_date'] = $packageVideo->expiration_date;
        }

        return $this->apiResponse(200, 'All Data', null, $response);
    }
}
