<?php

namespace App\Http\Controllers\Admin;


use App\Models\Country;
use App\Models\PackageVideo;
use Illuminate\Http\Request;
use App\Models\PackageVideoOffers;
use Illuminate\Support\Facades\App;
use App\Http\Controllers\Controller;
use App\Models\PackageVideoSubscriptions;
use App\Http\Requests\StorePackageVideoSubscriptionRequest;
use App\Http\Requests\UpdatePackageVideoSubscriptionRequest;

class PackageVideoSubscriptionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $user_id = null;
        $package_id = null;
        $from = date('Y-m-d');
        $to = date('Y-m-d');
        $countryCode = session('admin_country_code');
        $subscriptions = PackageVideoSubscriptions::when($countryCode, function ($query) use ($countryCode) {
            return $query->where('country_' . $countryCode, 1);
        })->orderBy('created_at', 'desc');
        if ($request->has('package_id') && $request->package_id != null) {
            $package_id = $request->package_id;
            $subscriptions = $subscriptions->where('package_id', $package_id);
        }
        if ($request->has('user_id') && $request->user_id != null) {
            $user_id = $request->user_id;
            $subscriptions = $subscriptions->where('user_id', $user_id);
        }
        if ($request->has('from') && $request->has('to')) {
            $subscriptions->where('subscription_date', '<=', date('Y-m-d', strtotime($request->from)));
            $subscriptions->where('expiration_date', '>=', date('Y-m-d', strtotime($request->to)));
            $from = $request->from;
            $to = $request->to;
        }
        $subscriptions = $subscriptions->paginate(20);
        $packages = PackageVideo::get();

        return view('admin.PackageVideoSubscriptions.index', compact('subscriptions', 'package_id', 'user_id', 'packages',  'from', 'to'));
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $packages = PackageVideo::pluck('name_' . App::getLocale(), 'id');
        $offers = PackageVideoOffers::pluck('title_' . App::getLocale(), 'id');
        $user_id = $request->user_id ?? null;
        $countries = Country::all();
        return view('admin.PackageVideoSubscriptions.create', compact('packages', 'offers', 'user_id', 'countries'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @return \Illuminate\Http\Response
     */
    public function store(StorePackageVideoSubscriptionRequest $request)
    {
        $validCountryCodes = Country::pluck('code')->toArray();

        $subscription = new PackageVideoSubscriptions;
        $subscription->user_id = $request->user_id;
        $subscription->package_id = $request->package_id;
        $subscription->offer_id = $request->offer_id;
        $subscription->price = $request->price;
        $subscription->subscription_date = $request->subscription_date;
        $subscription->expiration_date = $request->expiration_date;
        foreach ($validCountryCodes as $code) {
            $columnName = 'country_' . $code;
            $subscription->$columnName = $request->has('country_' . $code) ? 1 : 0;
        }

        $subscription->save();
        return redirect()->route('client.show', $subscription->user_id);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param \App\Models\Subscription $subscription
     * @return \Illuminate\Http\Response
     */
    public function edit(PackageVideoSubscriptions $subscription)
    {
        $packages = PackageVideo::pluck('name_' . App::getLocale(), 'id');
        $offers = PackageVideoOffers::where('package_id', $subscription->package_id)->pluck('title_' . App::getLocale(), 'id');
        $countries = Country::all();
        return view('admin.PackageVideoSubscriptions.edit', compact('subscription', 'packages', 'offers', 'countries'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @return \Illuminate\Http\Response
     */
    public function update(UpdatePackageVideoSubscriptionRequest $request, PackageVideoSubscriptions $subscription)
    {
        $validCountryCodes = Country::pluck('code')->toArray();

        $subscription->package_id = $request->package_id;
        $subscription->offer_id = $request->offer_id;
        $subscription->price = $request->price;
        $subscription->subscription_date = $request->subscription_date;
        $subscription->expiration_date = $request->expiration_date;
        foreach ($validCountryCodes as $code) {
            $columnName = 'country_' . $code;
            $subscription->$columnName = $request->has('country_' . $code) ? true : false;
        }
        $subscription->save();
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param \App\Models\Subscription $subscription
     * @return \Illuminate\Http\Response
     */
    public function destroy(PackageVideoSubscriptions $subscription)
    {
        $subscription->delete();
        session()->flash('notif', trans('messages.Moderator deleted successfully'));
        return redirect()->back();
    }
}
