<?php

namespace App\Http\Controllers\Admin;

use App\Models\Notification;
use App\Http\Controllers\Controller;
use App\Sys\Services\Notifications\NotificationService;
use Illuminate\Http\Request;


class NotificationController extends Controller
{
    protected $notificationService;

    public function __construct(NotificationService $notificationService)
    {
        $this->notificationService = $notificationService;
    }

    public function index(Request $request)
    {
        $sort_search = null;
        $notification_type = $request->notification_type ?? 'all';

        $notifications = Notification::with('user')->latest();

        if ($request->has('search')) {
            $sort_search = $request->search;
            $notifications = $notifications->where('title', 'like', '%' . $sort_search . '%');
        }

        if ($notification_type === 'topic') {
            $notifications = $notifications->whereNotNull('topic');
        } elseif ($notification_type === 'user') {
            $notifications = $notifications->whereNotNull('fcm_token');
        }

        $notifications = $notifications->paginate(20);

        return view('admin.notification.index', compact('notifications', 'sort_search', 'notification_type'));
    }

    public function create()
    {
        return view('admin.notification.create');
    }

    public function sendNotificationToUser($id)
    {
        return view('admin.notification.sendNotificationToUser', compact('id'));
    }

    public function sendNotificationToTopic(Request $request)
    {
        $notification = $this->notificationService->sendNotificationToTopic($request);

        if (!$notification) {
            session()->flash('error', trans('messages.error'));
            return redirect()->back();
        }

        session()->flash('success', trans('messages.add_successfully'));
        return redirect()->route('notification.index');
    }
}
