<?php

namespace App\Traits;

trait HasCountryTags
{
    public function getCountryTagsAttribute()
    {
        $countryColumns = collect($this->getAttributes())
            ->filter(function ($value, $key) {
                return str_starts_with($key, 'country_');
            })
            ->filter()
            ->mapWithKeys(function ($value, $key) {
                $country = strtoupper(str_replace('country_', '', $key));
                return [$country => $value];
            });

        return $countryColumns;
    }
}
