<?php

namespace App\Sys\Services\Packages;

use App\Sys\Services;
use App\Sys\Repositories\Packages\SubscriptionRepository;

class SubscriptionService extends Services
{
    protected $subscriptionRepository;

    public function __construct(SubscriptionRepository $subscriptionRepository)
    {
        $this->subscriptionRepository = $subscriptionRepository;
    }

    public function getLatestSubscriptionDetails($user)
    {
        $subscription = $this->subscriptionRepository->getLatestSubscriptionByUserId($user);

        if (!$subscription) {
            return false;
        }

        return $subscription;
    }
}
