<?php

namespace App\Sys\Services\Notifications;

use App\Sys\Repositories\Notifications\NotificationRepository;
use Illuminate\Support\Facades\Validator;
use App\Sys\Services;

class UserNotificationService extends Services
{
    private $notificationRepository;

    public function __construct(NotificationRepository $notificationRepository)
    {
        $this->notificationRepository = $notificationRepository;
    }

    public function getUserNotifications($user)
    {
        return $this->notificationRepository->getUserNotifications($user);
    }

    public function markNotificationAsRead($request, $user)
    {
        $validated = $request->validate([
            'notification_id' => 'required|integer|exists:notifications,id',
        ]);

        return $this->notificationRepository->markAsRead($validated['notification_id'], $user);
    }
}
