<?php

namespace App\Sys\Services\Countries;

use App\Models\Country;
use Illuminate\Support\Facades\Auth;

class CountryService
{
    protected $currentCountry; //'sa' 'ae' ecc
    protected $formattedCurrentCountry; //'country_sa' 'country_ae' ecc

    public function __construct()
    {
        $this->determineCurrentCountry();
    }

    protected function determineCurrentCountry()
    {
        $availableCountries = Country::getAvailableCountries();
        $defaultCountry = 'sa';

        if (Auth::check()) {
            $this->currentCountry = Auth::user()->country_code;
        } elseif (session()->has('country_code')) {
            $this->currentCountry = session('country_code');
        } else {
            $this->currentCountry = $defaultCountry;
        }

        if (!array_key_exists($this->currentCountry, $availableCountries)) {
            $this->currentCountry = $defaultCountry;
        }
    }

    public function getCurrentCountry()
    {
        return $this->currentCountry;
    }

    public function formatCountryString()
    {
        $this->formattedCurrentCountry = "country_{$this->currentCountry}";
        return $this->formattedCurrentCountry;
    }

    public function setCurrentCountry($countryCode)
    {
        $availableCountries = Country::getAvailableCountries();

        if (!array_key_exists($countryCode, $availableCountries)) {
            session()->flash('error', 'Invalid country code');
            return;
        }

        $this->currentCountry = $countryCode;

        if (Auth::check()) {
            Auth::user()->update(['country_code' => $countryCode]);
        }

        session(['country_code' => $countryCode]);
    }

    public function getAvailableCountries()
    {
        return Country::getAvailableCountries();
    }
}
