<?php

namespace App\Sys\Repositories\Packages;

use App\Models\Subscription;

class SubscriptionRepository
{
    public function getLatestSubscriptionByUserId($user)
    {
        return Subscription::with(['package' => function ($query) use ($user) {
            $query->where('country_' . $user->countryCode, true);
        }])
            ->where('user_id', $user->id)
            ->where('country_' . $user->countryCode, true)
            ->where('expiration_date', '>=', now())
            ->latest('subscription_date')
            ->first();
    }
}
