<?php

namespace App\Sys\Repositories\Packages;

use App\Models\Videos;
use App\Models\PackageVideo;
use App\Models\PackageVideoUserWatch;
use App\Models\PackageVideoSubscriptions;

class PackageVideoRepository
{
    public function getActivePackageVideoSubscriptionByUserId($user)
    {
        return PackageVideoSubscriptions::query()
            ->with(['package' => function ($query) use ($user) {
                $query->where('country_' . $user->countryCode, true);
            }])
            ->where('user_id', $user->id)
            ->where('country_' . $user->countryCode, true)
            ->where('expiration_date', '>=', now())
            ->latest('subscription_date')
            ->first();
    }
    public function getActiveVideoPackages($limit)
    {
        $countryCode = config('app.country');

        return PackageVideo::query()
            ->where('country_' . $countryCode, true)
            ->with(['offer' => function ($query) use ($countryCode) {
                $query->where('country_' . $countryCode, true);
            }])
            ->where('active', true)
            ->orderBy('arrangement')
            ->paginate($limit);
    }
    public function getVideosWithProgress($user, $packageId, $activeSubscriptionId)
    {
        $userId = $user->id;

        return PackageVideo::query()
            ->where('country_' . $user->countryCode, true)
            ->with(['offer' => function ($query) use ($user) {
                $query->where('country_' . $user->countryCode, true);
            }])
            ->with(['video' => function ($query) use ($userId, $activeSubscriptionId, $user) {
                $query->where('country_' . $user->countryCode, true)
                    ->with(['videoShows' => function ($query) use ($userId, $activeSubscriptionId, $user) {
                        $query->where('user_id', $userId)
                            ->where('subscription_id', $activeSubscriptionId)
                            ->where('country_' . $user->countryCode, true);
                    }]);
            }])
            ->find($packageId);
    }

    public function getCurrentUserWatchCount($user, $videoId, $activeSubscriptionId)
    {
        return PackageVideoUserWatch::query()
            ->where('user_id', $user->id)
            ->where('subscription_id', $activeSubscriptionId)
            ->where('video_id', $videoId)
            ->where('country_' . $user->countryCode, true)
            ->get();
    }

    public function getVideoUsingIdWithProgress($user, $videoId, $packageId)
    {
        return Videos::query()
            ->whereHas('packageVideo', function ($query) use ($packageId, $user) {
                $query->where('package_video.id', $packageId)
                    ->where('country_' . $user->countryCode, true);
            })
            ->where('country_' . $user->countryCode, true)
            ->find($videoId);
    }


    public function incrementWatchCount($user, $videoId, $packageVideoSubscription, $videoShows = null)
    {
        if ($videoShows) {
            // If the videoShow exists, increment the count_watch
            $videoShows->count_watch += 1;
            $videoShows->save();
        } else {
            // If no entry exists, create a new PackageVideoVideo object
            $packageVideoVideo = new PackageVideoUserWatch();
            $packageVideoVideo->video_id = $videoId;
            $packageVideoVideo->user_id = $user->id;
            $packageVideoVideo->package_id = $packageVideoSubscription->package_id;
            $packageVideoVideo->subscription_id = $packageVideoSubscription->id;
            $packageVideoVideo->count_watch = 1;

            $propertyName = 'country_' . $user->countryCode;
            $packageVideoVideo->{$propertyName} = 1;

            $packageVideoVideo->save();
        }
    }
}
