<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use PHPOpenSourceSaver\JWTAuth\Contracts\JWTSubject;

class User extends Authenticatable implements JWTSubject
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'phone',
        'gender',
        'email',
        'role_id',
        'user_type',
        'password',
        'enabel_sound',
        'flash_message',
        'imported_user',
        'imported_id',
        'package_id',
        'country_id',
        'country_code',
        'language_code',
        'fcm_token'
    ];

    public function country()
    {
        return $this->belongsTo(Country::class, 'country_id');
    }

    public function role()
    {
        return $this->belongsTo(Role::class, 'role_id');
    }

    public function results()
    {
        return $this->hasMany(Result::class, 'user_id');
    }

    public function subscriptions()
    {
        return $this->hasMany(Subscription::class, 'user_id');
    }

    public function favoriteQuestions()
    {
        return $this->belongsToMany(Question::class, 'favorite_questions', 'user_id', 'question_id');
    }

    public function notifications()
    {
        return $this->hasMany(Notification::class);
    }

    public function notificationReads()
    {
        return $this->hasMany(NotificationRead::class);
    }

    public function hasAbitity($ability)
    {
        $role = $this->role;
        if (!$role) {
            return false;
        }
        if (in_array($ability, $role->permissions)) {
            return true;
        }
        return false;
    }

    public function getCountryCodeAttribute()
    {
        return $this->attributes['country_code'] ?? 'sa';
    }

    public function getLanguageCodeAttribute()
    {
        return $this->attributes['language_code'] ?? 'ar';
    }

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function getJWTIdentifier()
    {
        return $this->getKey();
    }
    public function getJWTCustomClaims()
    {
        return [];
    }
}
