<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Notification extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'body',
        'action',
        'user_id',
        'fcm_token',
        'topic',
    ];
    protected $appends = ['is_read'];
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function notificationRead()
    {
        return $this->hasMany(NotificationRead::class);
    }

    public function getIsReadAttribute()
    {
        return $this->notificationRead()->exists();
    }
}
