<?php

namespace App\Http\Controllers\Api\Results;

use App\ApiResponse;
use App\Http\Controllers\Controller;
use App\Sys\Services\Results\ProgressService;
use Illuminate\Support\Facades\Auth;

class ProgressController extends Controller
{
    use ApiResponse;

    protected $progressService;

    public function __construct(ProgressService $progressService)
    {
        $this->progressService = $progressService;
    }

    public function ExamPackageProgress()
    {
        $user = Auth::guard('api')->user();

        $response = $this->progressService->getCurrentExamPackageProgress($user);

        if (! $response) {
            $error = $this->progressService->errors();

            return $this->apiResponse(400, 'fail', $error, null);
        }

        return $this->apiResponse(200, 'success', null, $response);
    }
}
