<?php

namespace App\Http\Controllers\Api\Packages;

use App\ApiResponse;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Http\Resources\PackageVideoCollection;
use App\Http\Resources\PackageVideoResource;
use App\Sys\Services\Packages\PackageVideoService;

class PackageVideoController extends Controller
{
    use ApiResponse;

    protected $packageVideoService;

    public function __construct(PackageVideoService $packageVideoService)
    {
        $this->packageVideoService = $packageVideoService;
    }

    public function packages($limit)
    {
        $response = $this->packageVideoService->getActivePackages($limit);

        if (! $response) {
            return $this->apiResponse(400, 'fail', null, null);
        }

        $packages = new PackageVideoCollection($response);

        return $this->apiResponse(200, 'All Data', null, $packages);
    }

    public function subscribedPackageVideos()
    {
        $user = Auth::guard('api')->user();

        $response = $this->packageVideoService->getVideosWithWatchProgress($user);

        if (! $response) {
            return $this->apiResponse(400, 'fail', $this->packageVideoService->errors(), null);
        }

        $videos = new PackageVideoResource($response);

        return $this->apiResponse(200, 'All Data', null, $videos);
    }

    public function getSelectedVideo($videoId)
    {
        $user = Auth::guard('api')->user();

        $result = $this->packageVideoService->getSelectedVideoById($user, $videoId);

        if (! $result) {
            return $this->apiResponse(400, 'fail', $this->packageVideoService->errors(), null);
        }

        $video = $result['video'];
        $videoShow = $result['videoShow'];

        $response = [
            'url' => url('/api/taher/packages/videos/get/iframe/' . $video->url),
            'current_watch_count' => $videoShow->count_watch ?? 1,
            'photo' => $video->photo,
        ];
        return $this->apiResponse(200, 'All Data', null, $response);
    }

    public function getSelectedIframeVideo($videoUrlCode)
    {
        return view('site.videoIframe', compact('videoUrlCode'));
    }
}
