<?php

namespace App\Http\Controllers\Api\General;

use App\ApiResponse;
use App\Http\Controllers\Controller;
use App\Http\Resources\PaymentMethodResourceCollection;
use App\Models\User;
use Mollie\Laravel\Facades\Mollie;

class PaymentControllers extends Controller
{
    use ApiResponse;

    public function getPaymentMethods()
    {

        $methods = Mollie::api()->methods->allActive();
        $paymentMethods = collect($methods);
        $collection = new PaymentMethodResourceCollection($paymentMethods);

        return $this->apiResponse(200, 'paymentMethods', null, $collection);
    }

    public function checkPayment($id)
    {
        $user = User::find($id);
        $data['paymentStatus'] = $user->payment_status;
        $data['massage'] = $user->flash_message;
        if (in_array($user->payment_status, ['paid', 'open'])) {
            $user->payment_status = null;
            $user->flash_message = null;
            $user->package_id = null;
            $user->save();
        }

        return $this->apiResponse('200', 'checking', null, $data);
    }

    public function redirectUrl()
    {
        return view('site.payment');
    }
}
