<?php

namespace App\Http\Controllers\Api\General;

use App\ApiResponse;
use App\Http\Controllers\Controller;
use App\Http\Resources\PageOptionsCollection;
use App\Http\Resources\PageResource;
use App\Sys\Services\General\StaticPageService;

class ContentController extends Controller
{
    use ApiResponse;
    protected $staticPageService;

    public function __construct(StaticPageService $staticPageService)
    {
        $this->staticPageService = $staticPageService;
    }

    public function getStaticPageContent()
    {
        $response = $this->staticPageService->staticContentOptions();

        if (! $response) {
            $error = $this->staticPageService->errors();

            return $this->apiResponse(400, 'fail', $error, null);
        }

        $responseResource = new PageOptionsCollection($response);

        return $this->apiResponse(200, 'All data', null, $responseResource);
    }

    public function getStaticPageContentById($id)
    {
        $response = $this->staticPageService->staticContentSelectedOption($id);

        if (! $response) {
            $error = $this->staticPageService->errors();

            return $this->apiResponse(400, 'fail', $error, null);
        }

        $responseResource = new PageResource($response);

        return $this->apiResponse(200, 'All data', null, $responseResource);
    }
}
