<?php

namespace App\Http\Controllers\Api\Blogs;

use App\ApiResponse;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Sys\Services\Blogs\BlogService;
use App\Http\Resources\BlogCategoryCollection;
use App\Sys\Services\Blogs\BlogCategoryService;

class BlogCategoriesController extends Controller
{
    use ApiResponse;
    protected $blogCategoryService;

    public function __construct(BlogCategoryService $blogCategoryService)
    {
        $this->blogCategoryService = $blogCategoryService;
    }

    public function categories($limit)
    {
        $categories = $this->blogCategoryService->getBlogCategories($limit);

        if (! $categories) {
            return $this->apiResponse(400, 'Fail', null, null);
        }

        $response = new BlogCategoryCollection($categories);

        return $this->apiResponse(200, 'All Data', null, $response);
    }
}
