<?php

namespace App\Http\Controllers\Admin;

use App\Models\Videos;
use App\Models\Country;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;

class VideoControllers extends Controller
{
    public function index()
    {
        $countryCode = session('admin_country_code');
        $videos = Videos::when($countryCode, function ($query) use ($countryCode) {
            return $query->where('country_' . $countryCode, 1);
        })->with('videoShows')->paginate(20);
        return view('admin.videos.index')->with('videos', $videos);
    }
    public function addView()
    {
        $countries = Country::all();

        return view('admin.videos.add', compact('countries'));
    }
    public function add(Request $request)
    {
        $request->validate([
            'image' => ['required', 'image', 'mimes:jpeg,png,jpg,gif,svg'],
            'url_ar' => ['required', 'numeric'],
            'url_en' => ['required', 'numeric'],
            'url_nl' => ['required', 'numeric'],
            'name_ar' => ['required'],
            'name_en' => ['required'],
            'name_nl' => ['required'],
        ]);
        $nameDesk = null;
        if ($request->file('image')) {
            $nameDesk =  saveFile($request->file('image'), 'video');
        }
        $validCountryCodes = Country::pluck('code')->toArray();

        $newVideo = new Videos();
        $newVideo->url_ar = $request->url_ar;
        $newVideo->url_en = $request->url_en;
        $newVideo->url_nl = $request->url_nl;
        $newVideo->name_ar = $request->name_ar;
        $newVideo->name_en = $request->name_en;
        $newVideo->name_nl = $request->name_nl;
        $newVideo->desc_ar =    $request->description_ar;
        $newVideo->desc_en =  $request->description_en;
        $newVideo->desc_nl =  $request->description_nl;
        $newVideo->image = $nameDesk;
        $newVideo->is_active =  ($request->is_active == 'on') ? 1 : 0;
        foreach ($validCountryCodes as $code) {
            $columnName = 'country_' . $code;
            $newVideo->$columnName = $request->has('country_' . $code) ? 1 : 0;
        }
        if ($newVideo->save()) {
            session()->flash('notif', trans('messages.add_successfully'));
            return redirect()->route('video.index');
        }
        return redirect()->back();
    }
    public function updated($id)
    {
        $video = Videos::find($id);
        $countries = Country::all();
        if (!empty($video))
            return view('admin.videos.updated', compact('video', 'countries'));

        session()->flash('notif', trans('messages.Not Found'));
        return redirect()->back();
    }
    public function updatedProcess(Request $request, $id)
    {
        $newVideo = Videos::find($id);
        $request->all();
        if (!empty($newVideo)) {
            $validCountryCodes = Country::pluck('code')->toArray();
            $request->validate([
                'image' => ['nullable', 'image', 'mimes:jpeg,png,jpg,gif,svg'],
                'url_ar' => ['required', 'numeric'],
                'url_en' => ['required', 'numeric'],
                'url_nl' => ['required', 'numeric'],
                'name_ar' => ['required'],
                'name_en' => ['required'],
                'name_nl' => ['required'],
            ]);

            if ($request->file('image')) {
                $nameDesk =  saveFile($request->file('image'), 'video');
                $newVideo->image = $nameDesk;
            }
            $newVideo->url_ar = $request->url_ar;
            $newVideo->url_en = $request->url_en;
            $newVideo->url_nl = $request->url_nl;
            $newVideo->name_ar = $request->name_ar;
            $newVideo->name_en = $request->name_en;
            $newVideo->name_nl = $request->name_nl;
            $newVideo->desc_ar = $request->description_ar;
            $newVideo->desc_en = $request->description_en;
            $newVideo->desc_nl = $request->description_nl;
            foreach ($validCountryCodes as $code) {
                $columnName = 'country_' . $code;
                $newVideo->$columnName = $request->has('country_' . $code) ? true : false;
            }
            if ($newVideo->save()) {
                session()->flash('notif', trans('messages.updated_successfully'));
                return redirect()->route('video.index');
            }
            return redirect()->back();
        }
        return redirect()->back();
    }
    public function changeStatus(Request $request)
    {
        $newVideo = Videos::find($request->id);
        if (!empty($newVideo)) {
            $newVideo->is_active = $newVideo->is_active == 1 ? 0 : 1;
            if ($newVideo->save()) {
                return 1;
            }
            return 0;
        }
        return 0;
    }
    public function destroy($id)
    {
        $videos = Videos::find($id);
        $videos->delete();
        session()->flash('notif', trans('messages.Video deleted successfully'));
        return redirect()->route('video.index');
    }
}
