<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\BlogCategory;
use App\Http\Requests\StoreBlogCategoryRequest;
use App\Http\Requests\UpdateBlogCategoryRequest;
use App\Models\Country;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;

class BlogCategoryController extends Controller
{
    public function index(Request $request)
    {
        $sort_search = null;
        $countryCode = session('admin_country_code');
        $blogCategories = BlogCategory::when($countryCode, function ($query) use ($countryCode) {
            return $query->where('country_' . $countryCode, 1);
        })->orderBy('created_at', 'desc');

        if ($request->has('search')) {
            $sort_search = $request->search;
            $blogCategories = $blogCategories->where('name_' . App::getLocale(), 'like', '%' . $sort_search . '%');
        }

        $blogCategories = $blogCategories->paginate(20);
        return view('admin.BlogCategory.index', compact('blogCategories', 'sort_search'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $countries = Country::all();

        return view('admin.BlogCategory.create', compact('countries'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreBlogCategoryRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreBlogCategoryRequest $request)
    {
        $validCountryCodes = Country::pluck('code')->toArray();

        $blogCategory = new BlogCategory;
        if ($request->file('image')) {
            $request->image = saveFile($request->file('image'), 'blogCategory');
        }
        $blogCategory->name_ar = $request->name_ar;
        $blogCategory->name_en = $request->name_en;
        $blogCategory->slug_ar = $request->slug_ar;
        $blogCategory->slug_en = $request->slug_en;
        $blogCategory->name_nl = $request->name_nl;
        $blogCategory->slug_nl = $request->slug_nl;
        $blogCategory->arrangement = $request->arrangement;
        $blogCategory->image = $request->image;

        foreach ($validCountryCodes as $code) {
            $columnName = 'country_' . $code;
            $blogCategory->$columnName = $request->has('country_' . $code) ? 1 : 0;
        }

        $blogCategory->save();

        return redirect()->route('blogCategory.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\BlogCategory  $blogCategory
     * @return \Illuminate\Http\Response
     */
    public function show(BlogCategory $blogCategory)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\BlogCategory  $blogCategory
     * @return \Illuminate\Http\Response
     */
    public function edit(BlogCategory $blogCategory)
    {
        $countries = Country::all();
        return view('admin.BlogCategory.edit', compact('blogCategory', 'countries'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateBlogCategoryRequest  $request
     * @param  \App\Models\BlogCategory  $blogCategory
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateBlogCategoryRequest $request, BlogCategory $blogCategory)
    {
        $validCountryCodes = Country::pluck('code')->toArray();

        if ($request->file('image')) {
            if ($blogCategory->image && file_exists(public_path($blogCategory->image))) {
                unlink(public_path($blogCategory->image));
            }
            $request->image = saveFile($request->file('image'), 'blogCategory');
            $blogCategory->image = $request->image;
        }
        $blogCategory->name_ar = $request->name_ar;
        $blogCategory->name_en = $request->name_en;
        $blogCategory->slug_ar = $request->slug_ar;
        $blogCategory->slug_en = $request->slug_en;
        $blogCategory->name_nl = $request->name_nl;
        $blogCategory->slug_nl = $request->slug_nl;
        $blogCategory->arrangement = $request->arrangement;

        foreach ($validCountryCodes as $code) {
            $columnName = 'country_' . $code;
            $blogCategory->$columnName = $request->has('country_' . $code) ? true : false;
        }

        $blogCategory->save();
        return redirect()->route('blogCategory.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\BlogCategory  $blogCategory
     * @return \Illuminate\Http\Response
     */
    public function destroy(BlogCategory $blogCategory)
    {
        if ($blogCategory->image && file_exists(public_path($blogCategory->image))) {
            unlink(public_path($blogCategory->image));
        }
        $blogCategory->delete();
        session()->flash('notif', trans('messages.Category deleted successfully'));
        return redirect()->route('blogCategory.index');
    }
}
