<?php

use App\Http\Controllers\Api\General\YoutubeVideoController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\Auth\AuthController;
use App\Http\Controllers\Api\Exams\ExamController;
use App\Http\Controllers\Api\Blogs\BlogsController;
use App\Http\Controllers\Api\General\ContentController;
use App\Http\Controllers\Api\Theories\TheoryController;
use App\Http\Controllers\Api\General\PaymentControllers;
use App\Http\Controllers\Api\Packages\PackageController;
use App\Http\Controllers\Api\Results\ProgressController;
use App\Http\Controllers\Api\Blogs\BlogCategoriesController;
use App\Http\Controllers\Api\General\CommunicationController;
use App\Http\Controllers\Api\Packages\PackageVideoController;
use App\Http\Controllers\Api\General\GeneralPackageControllers;
use App\Http\Controllers\Api\Questions\ReportQuestionController;
use App\Http\Controllers\Api\Notifications\NotificationController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::prefix('auth')->group(
    function () {
        Route::post('/login', [AuthController::class, 'login'])->name('auth.login');
        Route::post('/register', [AuthController::class, 'register'])->name('auth.register');
        Route::post('/reset/otp', [AuthController::class, 'getResetPassword'])->name('auth.reset-otp');
        Route::post('/reset/password/otp', [AuthController::class, 'resetPassword'])->name('auth.reset-password-otp');
    }
);

Route::prefix('general')->group(
    function () {
        Route::pattern('id', '[0-9]+');
        // About & privacy
        Route::get('/static-content/options', [ContentController::class, 'getStaticPageContent'])->name('general.contentPage');
        Route::get('/static-content/options/{id}', [ContentController::class, 'getStaticPageContentById'])->name('general.selectedContentPage');
        // ContactUs form
        Route::post('/communication/contact-us/send', [CommunicationController::class, 'handleContactForm'])->name('general.communication.contactUs');
    }
);

Route::prefix('packages')->group(
    function () {
        //package exam
        Route::get('get/{limit}', [PackageController::class, 'packages'])->name('packages.active');

        //Video package
        Route::get('/videos/get/{limit}', [PackageVideoController::class, 'packages'])->name('packages-video.active');
        // test exam questions
        Route::prefix('exams')->group(
            function () {
                Route::get('/test-exam-questions', [ExamController::class, 'getTestPackageExamQuestions'])->name('test-exams.questions');
            }
        );
    }

);

//theory packages
Route::prefix('theory')->group(
    function () {
        Route::get('/packages/get/{limit}', [TheoryController::class, 'theories'])->name('load.theories.limit');
    }
);

// general communication methods
Route::prefix('general')->group(function () {
    Route::get('/communication/methods', [CommunicationController::class, 'getCommunicationMethods'])->name('general.communication.methods');
});

// Content
Route::prefix('content')->group(function () {
    Route::get('/youtube-video', [YoutubeVideoController::class, 'getSingleHomeVideo'])->name('content.youtube-video');
});

// Blog
Route::prefix('blog')->group(function () {
    Route::pattern('id', '[0-9]+');

    // Blog category
    Route::get('/categories/{limit}', [BlogCategoriesController::class, 'categories'])->name('load.blogCategories.limit');
    Route::get('/category/post/{limit}', [BlogsController::class, 'blogsByCategoryId'])->name('load.CategoriesBlogs.limit');
    // Blog posts
    Route::get('/posts/get/{limit}', [BlogsController::class, 'blogs'])->name('load.blogs.limit');
    Route::get('/post/{id}', [BlogsController::class, 'blogById'])->name('blog.post.get');
});

Route::middleware('CheckAuthApi')->namespace('Api')->group(function () {
    Route::pattern('id', '[0-9]+');

    // Auth Controllers
    Route::prefix('auth')->group(function () {
        Route::get('/me', [AuthController::class, 'me'])->name('auth.me');
        Route::post('/refresh/token', [AuthController::class, 'refresh'])->name('auth.token-refresh');
        Route::post('/updated', [AuthController::class, 'updated'])->name('auth.updated');
        Route::post('/updated/password', [AuthController::class, 'password'])->name('auth.updated-password');
        Route::post('/fcm-token', [AuthController::class, 'updateFcmToken'])->name('auth.fcm-token');
        // country and language preferences
        Route::get('/preferences', [AuthController::class, 'getUserPreferences'])->name('auth.preferences.get');
        Route::post('/preferences', [AuthController::class, 'setUserPreferences'])->name('auth.preferences.set');
    });
    // any general data
    Route::prefix('general')->group(function () {
        Route::get('/payment-method', [PaymentControllers::class, 'getPaymentMethods'])->name('general.payment-methods');
        Route::get('/checkPayment/{id}', [PaymentControllers::class, 'checkPayment'])->name('general.checkPayment');
        Route::get('redirectUrl-api-payment', [PaymentControllers::class, 'redirectUrl'])->name('general.redirectUrl');
    });
    Route::prefix('packages')->group(function () {
        //Video package
        Route::get('/videos/get/iframe/{videoUrlCode}', [PackageVideoController::class, 'getSelectedIframeVideo'])->name('subscribedPackage.video.selectIframe');
        Route::get('/subscribed-videos/get', [PackageVideoController::class, 'subscribedPackageVideos'])->name('subscribed.package.video');
        Route::get('/videos/get/select/{id}', [PackageVideoController::class, 'getSelectedVideo'])->name('subscribedPackage.video.select');

        // the current active package's exams + showing is_locked for when the attempts exceeds the attempts for each exam
        Route::prefix('exams')->group(function () {
            Route::get('/user/subscribed-exams/{limit}', [ExamController::class, 'getSubscribedPackageExams'])->name('user.subscribed-exams');
            Route::get('/exam-questions', [ExamController::class, 'getSubscribedPackageExamQuestions'])->name('subscribed-exams.questions');
            Route::post('/exam-results', [ExamController::class, 'saveExamResults'])->name('exams.questions-answer');
        });

        Route::get('/mySubscription-details', [GeneralPackageControllers::class, 'getSubscriptionDetails'])->name('general.SubscriptionDetails');
    });
    Route::prefix('questions')->group(function () {
        //favorite question
        /*
        Route::get('/favorite-questions/get/{limit}', [FavoriteQuestionController::class, 'getFavoriteQuestions'])->name('favoriteQuestions.get');
        Route::get('/favorite-question/{id}', [FavoriteQuestionController::class, 'getSelectedFavoriteQuestion'])->name('favoriteQuestion.get');
        */
        //report question
        Route::post('report/question', [ReportQuestionController::class, 'reportQuestion'])->name('report.question.create');
    });

    Route::prefix('exams')->group(function () {
        Route::get('/exam-questions/{id}', [ExamController::class, 'getSubscribedPackageExamQuestions'])->name('subscribed-exams.questions');
    });

    Route::prefix('results')->group(function () {
        Route::get('/all-progress', [ProgressController::class, 'ExamPackageProgress'])->name('progress-exams.results');
    });

    // Theory
    Route::prefix('theory')->group(function () {
        Route::get('/get/{id}', [TheoryController::class, 'theoryById'])->name('theory.get');
    });

    // Notifications
    Route::prefix('notifications')->group(function () {
        Route::get('/user-notifications', [NotificationController::class, 'userNotificationsIndex'])->name('user.notifications.index');
        Route::post('/mark-as-read', [NotificationController::class, 'markAsRead'])->name('user.notifications.markAsRead');
    });
});

// web hock
Route::post('mollie-webhooks/{type}', [App\Http\Controllers\Site\ClientController::class, 'handleWebhookNotification'])->name('webhooks.mollie');
Route::post('mollie-webhooks-theory', [App\Http\Controllers\Site\ClientController::class, 'handleWebhookTheoryNotification'])->name('webhooks.mollieTheory');
Route::post('mollie-webhooks-packageVideos', [App\Http\Controllers\Site\PackagesVideosControllers::class, 'handleWebhookpackageVideos'])->name('webhooks.packageVideos');
