@extends('admin.layouts.main')
@section('content')
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title">{{ trans('messages.Add Package') }}</h3>
            </div>

        </div>
    </div>
    <style>
        .bootstrap-tagsinput {
            width: 100%;
            padding: 0.6em;
        }
    </style>
    <!-- Main content -->
    <section class="content">
        {!! Form::open([
            'method' => 'PUT',
            'route' => ['theoryPackage.update', $theoryPackage->id],
            'files' => true,
            'id' => 'edit-theoryPackage-form',
        ]) !!}
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="box">
                    <div class="box-body">
                        <!-- Nav tabs -->
                        <ul class="nav nav-tabs customtab2" role="tablist">
                            <li class="nav-item"><a class="nav-link active" data-toggle="tab" href="#home7"
                                    role="tab"><span class="hidden-sm-up"><i class="ion-home"></i></span> <span
                                        class="hidden-xs-down">{{ trans('messages.Arabic') }}</span></a></li>
                            <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#profile7" role="tab"><span
                                        class="hidden-sm-up"><i class="ion-person"></i></span> <span
                                        class="hidden-xs-down">{{ trans('messages.Netherland') }}</span></a></li>
                            <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#home8" role="tab"><span
                                        class="hidden-sm-up"><i class="ion-home"></i></span> <span
                                        class="hidden-xs-down">{{ trans('messages.English') }}</span></a></li>
                        </ul>

                        <!-- Tab panes -->
                        <div class="tab-content">
                            <div class="tab-pane active" id="home7" role="tabpanel">
                                <div class="p-15">
                                    <div class="form-group">
                                        <label for="name_ar">{{ trans('messages.Name Ar') }}
                                        </label>
                                        <div>
                                            {!! Form::text('name_ar', $theoryPackage->name_ar, [
                                                'class' => 'form-control',
                                                'placeholder' => trans('messages.Name Ar'),
                                            ]) !!}
                                        </div>
                                        @error('name_ar')
                                            <div class="badge badge-danger text-center" style="width: 100%">
                                                {{ $message }}
                                            </div>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="short_desc_ar">{{ trans('messages.Notes Ar') }}
                                        </label>
                                        <div>
                                            {!! Form::textarea('short_desc_ar', $theoryPackage->short_desc_ar, [
                                                'class' => 'form-control',
                                                'placeholder' => trans('messages.Notes Ar'),
                                            ]) !!}
                                        </div>
                                        @error('short_desc_ar')
                                            <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                            </div>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="notes_ar">{{ trans('messages.Notes Ar') }}
                                        </label>
                                        <div>
                                            {!! Form::textarea('notes_ar', $theoryPackage->notes_ar, [
                                                'id' => 'editor1',
                                                'class' => 'form-control',
                                                'placeholder' => trans('messages.Notes Ar'),
                                            ]) !!}
                                        </div>
                                        @error('notes_ar')
                                            <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                            </div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane active" id="home8" role="tabpanel">
                                <div class="p-15">
                                    <div class="form-group">
                                        <label for="name_en">{{ trans('messages.Name EN') }}
                                        </label>
                                        <div>
                                            {!! Form::text('name_en', $theoryPackage->name_en, [
                                                'class' => 'form-control',
                                                'placeholder' => trans('messages.Name EN'),
                                            ]) !!}
                                        </div>
                                        @error('name_en')
                                            <div class="badge badge-danger text-center" style="width: 100%">
                                                {{ $message }}
                                            </div>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="short_desc_en">{{ trans('messages.Notes EN') }}
                                        </label>
                                        <div>
                                            {!! Form::textarea('short_desc_en', $theoryPackage->short_desc_en, [
                                                'class' => 'form-control',
                                                'placeholder' => trans('messages.Notes EN'),
                                            ]) !!}
                                        </div>
                                        @error('short_desc_en')
                                            <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                            </div>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="notes_en">{{ trans('messages.Notes EN') }}
                                        </label>
                                        <div>
                                            {!! Form::textarea('notes_en', $theoryPackage->notes_en, [
                                                'id' => 'editoren',
                                                'class' => 'form-control',
                                                'placeholder' => trans('messages.Notes EN'),
                                            ]) !!}
                                        </div>
                                        @error('notes_en')
                                            <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                            </div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="profile7" role="tabpanel">
                                <div class="p-15">
                                    <div class="form-group">
                                        <label for="name_nl">{{ trans('messages.Name Nl') }}
                                        </label>
                                        <div>
                                            {!! Form::text('name_nl', $theoryPackage->name_nl, [
                                                'class' => 'form-control',
                                                'placeholder' => trans('messages.Name Nl'),
                                            ]) !!}
                                        </div>
                                        @error('name_nl')
                                            <div class="badge badge-danger text-center" style="width: 100%">
                                                {{ $message }}
                                            </div>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="short_desc_nl">{{ trans('messages.Notes Nl') }}
                                        </label>
                                        <div>
                                            {!! Form::textarea('short_desc_nl', $theoryPackage->short_desc_nl, [
                                                'class' => 'form-control',
                                                'placeholder' => trans('messages.Notes Nl'),
                                            ]) !!}
                                        </div>
                                        @error('short_desc_nl')
                                            <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                            </div>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="notes_nl">{{ trans('messages.Notes Nl') }}
                                        </label>
                                        <div>
                                            {!! Form::textarea('notes_nl', $theoryPackage->notes_nl, [
                                                'id' => 'editor2',
                                                'class' => 'form-control',
                                                'placeholder' => trans('messages.Notes Nl'),
                                            ]) !!}
                                        </div>
                                        @error('notes_nl')
                                            <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                            </div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12" style="margin-bottom: 5px; background: #8950FC; color: #fff;padding: 5px;">في
                            حاله اختيار
                            طريقة العرض ( نص ) سوف يتم عرض هذه الصور
                        </div>

                        <div class="row"
                            style="margin-bottom: 5px;border-bottom:1px #8950FC solid;border-right:1px #8950FC solid;">
                            <div class="form-group">
                                <div class="col-lg-12 mx-auto">
                                    <div class="custom-file-container">
                                        <div class="custom-file">
                                            <input type="file" name="image" class="custom-file-input" id="image">
                                            <label class="custom-file-label"
                                                for="image">{{ trans('photo_desktop') }}</label>
                                        </div>

                                        <div class="bg-lightest p-10 rounded5 dvPreview text-center customer_file_input_conto"
                                            style="width: 100%;margin-top: 1em;height: 10em;">
                                            @if (!empty($theoryPackage->image) && file_exists(public_path() . '/' . $theoryPackage->image))
                                                @if (in_array(pathinfo($theoryPackage->image, PATHINFO_EXTENSION), ['JPG', 'jpg', 'jpeg', 'gif', 'png', 'bmp']))
                                                    <img style="max-width: 100%;height: 100%;"
                                                        src="{{ url('/' . $theoryPackage->image) }}" alt="">
                                                    <video style="max-width: 100%;height: 100%;display: none;" controls
                                                        autoplay>
                                                    </video>
                                                @else
                                                    <img style="max-width: 100%;height: 100%;display: none;"
                                                        src="{{ url('/images/noimg.png') }}" alt="">
                                                    <video style="max-width: 100%;height: 100%;"
                                                        src="{{ url('/' . $theoryPackage->image) }}" controls autoplay>
                                                    </video>
                                                @endif
                                            @else
                                                <img style="max-width: 100%;height: 100%;"
                                                    src="{{ url('/images/noimg.png') }}" alt="">
                                                <video style="max-width: 100%;height: 100%;display: none;" controls
                                                    autoplay>
                                                </video>
                                            @endif
                                        </div>
                                    </div>
                                    @error('image')
                                        <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                        </div>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="col-lg-12 mx-auto">
                                    <div class="custom-file-container_2">
                                        <div class="custom-file_2">
                                            <input type="file" name="photo_phone" class="custom-file-input_2"
                                                id="image_2">
                                            <label class="custom-file-label"
                                                for="image_2">{{ trans('messages.photo_phone') }}</label>
                                        </div>
                                        <div class="bg-lightest p-10 rounded5 dvPreview text-center custem-css-templet_2"
                                            style="width: 100%;margin-top: 1em;height: 10em;">
                                            @if (!empty($theoryPackage->photo_phone) && file_exists(public_path() . '/' . $theoryPackage->photo_phone))
                                                @if (in_array(pathinfo($theoryPackage->photo_phone, PATHINFO_EXTENSION), ['JPG', 'jpg', 'jpeg', 'gif', 'png', 'bmp']))
                                                    <img style="max-width: 100%;height: 100%;"
                                                        src="{{ url('/' . $theoryPackage->photo_phone) }}"
                                                        alt="">
                                                    <video style="max-width: 100%;height: 100%;display: none;" controls
                                                        autoplay>
                                                    </video>
                                                @else
                                                    <img style="max-width: 100%;height: 100%;display: none;"
                                                        src="{{ url('/images/noimg.png') }}" alt="">
                                                    <video style="max-width: 100%;height: 100%;"
                                                        src="{{ url('/' . $theoryPackage->photo_phone) }}" controls
                                                        autoplay>
                                                    </video>
                                                @endif
                                            @else
                                                <img style="max-width: 100%;height: 100%;"
                                                    src="{{ url('/images/noimg.png') }}" alt="">
                                                <video style="max-width: 100%;height: 100%;display: none;" controls
                                                    autoplay>
                                                </video>
                                            @endif
                                        </div>
                                    </div>
                                    @error('photo_desktop')
                                        <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                        </div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="price">{{ trans('messages.Price') }}
                            </label>
                            <div>
                                {!! Form::number('price', $theoryPackage->price, [
                                    'class' => 'form-control',
                                    'placeholder' => trans('messages.Price'),
                                ]) !!}
                            </div>
                            @error('price')
                                <div class="badge badge-danger text-center" style="width: 100%">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for="expiration_duration_in_dayes">{{ trans('messages.Expiration duration') }}
                            </label>
                            <div>
                                {!! Form::number('expiration_duration_in_dayes', $theoryPackage->expiration_duration_in_dayes, [
                                    'class' => 'form-control',
                                    'placeholder' => trans('messages.Expiration duration'),
                                ]) !!}
                            </div>
                            @error('expiration_duration_in_dayes')
                                <div class="badge badge-danger text-center" style="width: 100%">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for="arrangement">{{ trans('messages.Arrangement') }}
                            </label>
                            <div>
                                {!! Form::number('arrangement', $theoryPackage->arrangement, [
                                    'class' => 'form-control',
                                    'placeholder' => trans('messages.Expiration duration'),
                                ]) !!}
                            </div>
                            @error('arrangement')
                                <div class="badge badge-danger text-center" style="width: 100%">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="row">
                            <div class="col-xl-6">
                                <div class="form-group">
                                    <label for="arrangement">{{ trans('messages.color_background') }}
                                    </label>
                                    <div>
                                        {!! Form::color('color_background', $theoryPackage->color_background, [
                                            'class' => 'form-control',
                                        ]) !!}
                                    </div>
                                    @error('color_background')
                                        <div class="badge badge-danger text-center" style="width: 100%">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="form-group">
                                    <label for="arrangement">{{ trans('messages.color_border') }}
                                    </label>
                                    <div>
                                        {!! Form::color('color_border', $theoryPackage->color_border, [
                                            'class' => 'form-control',
                                        ]) !!}
                                    </div>
                                    @error('color_border')
                                        <div class="badge badge-danger text-center" style="width: 100%">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="checkbox">
                                {!! Form::checkbox('show_in_home', null, $theoryPackage->show_in_home, ['id' => 'show_in_home']) !!}
                                <label for="show_in_home">{{ trans('messages.Show in home') }}</label>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="checkbox">
                                {!! Form::checkbox('enable', null, $theoryPackage->enable, ['id' => 'Checkbox_1']) !!}
                                <label for="Checkbox_1">{{ trans('messages.Enable') }}</label>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="label-default" for="type_view">{{ __('messages.type_view') }}:</label>
                            <select class="form-control select2-container" name="type_view" id="type_view">
                                <option value="text"
                                    @if (old('type_view') != null) {{ old('type_view') == 'text' ? 'selected' : '' }}
                                    @else
                                    {{ $theoryPackage->type_view == 'text' ? 'selected' : '' }} @endif>
                                    {{ __('messages.choseText') }}</option>
                                <option value="photo"
                                    @if (old('type_view') != null) {{ old('type_view') == 'photo' ? 'selected' : '' }}
                                    @else
                                    {{ $theoryPackage->type_view == 'photo' ? 'selected' : '' }} @endif>
                                    {{ __('messages.chosephoto') }}</option>
                            </select>
                        </div>
                        <div class="row">
                            <div class="form-group">
                                <div class="col-lg-12 mx-auto">
                                    <div class="custom-file-container">
                                        <div class="cove_desktop_ar_file">
                                            <input type="file" name="cove_desktop_ar" class="cove_desktop_ar-input"
                                                id="cove_desktop_ar">
                                            <label class="custom-file-label"
                                                for="cove_desktop_ar">{{ trans('messages.cove_desktop_ar') }}</label>
                                        </div>
                                        <div class="bg-lightest p-10 rounded5 dvPreview text-center cove_desktop_contorller_ar"
                                            style="width: 100%;margin-top: 1em;height: 10em;">
                                            @if (!empty($theoryPackage->cove_desktop_ar) && file_exists(public_path() . '/' . $theoryPackage->cove_desktop_ar))
                                                @if (in_array(pathinfo($theoryPackage->cove_desktop_ar, PATHINFO_EXTENSION), [
                                                        'JPG',
                                                        'jpg',
                                                        'jpeg',
                                                        'gif',
                                                        'png',
                                                        'bmp',
                                                    ]))
                                                    <img style="max-width: 100%;height: 100%;"
                                                        src="{{ url('/' . $theoryPackage->cove_desktop_ar) }}"
                                                        alt="">
                                                    <video style="max-width: 100%;height: 100%;display: none;" controls
                                                        autoplay>
                                                    </video>
                                                @else
                                                    <img style="max-width: 100%;height: 100%;display: none;"
                                                        src="{{ url('/images/noimg.png') }}" alt="">
                                                    <video style="max-width: 100%;height: 100%;"
                                                        src="{{ url('/' . $theoryPackage->cove_desktop_ar) }}" controls
                                                        autoplay>
                                                    </video>
                                                @endif
                                            @else
                                                <img style="max-width: 100%;height: 100%;"
                                                    src="{{ url('/images/noimg.png') }}" alt="">
                                                <video style="max-width: 100%;height: 100%;display: none;" controls
                                                    autoplay>
                                                </video>
                                            @endif
                                        </div>
                                    </div>
                                    @error('cove_desktop_ar')
                                        <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                        </div>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="col-lg-12 mx-auto">
                                    <div class="custom-file-container_2">
                                        <div class="cove_phone_ar_2">
                                            <input type="file" name="cove_phone_ar" class="cove_phone_ar_2"
                                                id="cove_phone_ar">
                                            <label class="custom-file-label"
                                                for="cove_phone_ar">{{ trans('messages.cove_phone_ar') }}</label>
                                        </div>
                                        <div class="bg-lightest p-10 rounded5 dvPreview text-center cove_phone_ar_controller_2"
                                            style="width: 100%;margin-top: 1em;height: 10em;">

                                            @if (!empty($theoryPackage->cove_phone_ar) && file_exists(public_path() . '/' . $theoryPackage->cove_phone_ar))
                                                @if (in_array(pathinfo($theoryPackage->cove_phone_ar, PATHINFO_EXTENSION), ['JPG', 'jpg', 'jpeg', 'gif', 'png', 'bmp']))
                                                    <img style="max-width: 100%;height: 100%;"
                                                        src="{{ url('/' . $theoryPackage->cove_phone_ar) }}"
                                                        alt="">
                                                    <video style="max-width: 100%;height: 100%;display: none;" controls
                                                        autoplay>
                                                    </video>
                                                @else
                                                    <img style="max-width: 100%;height: 100%;display: none;"
                                                        src="{{ url('/images/noimg.png') }}" alt="">
                                                    <video style="max-width: 100%;height: 100%;"
                                                        src="{{ url('/' . $theoryPackage->cove_phone_ar) }}" controls
                                                        autoplay>
                                                    </video>
                                                @endif
                                            @else
                                                <img style="max-width: 100%;height: 100%;"
                                                    src="{{ url('/images/noimg.png') }}" alt="">

                                                <video style="max-width: 100%;height: 100%;display: none;" controls
                                                    autoplay>
                                                </video>
                                            @endif
                                        </div>
                                    </div>
                                    @error('cove_phone_ar')
                                        <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                        </div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group">
                                <div class="col-lg-12 mx-auto">
                                    <div class="custom-file-container_2">
                                        <div class="cove_desktop_en_2">
                                            <input type="file" name="cove_desktop_en" class="cove_desktop_en_2"
                                                id="cove_desktop_en">
                                            <label class="custom-file-label"
                                                for="cove_desktop_en">{{ trans('messages.cove_desktop_en') }}</label>
                                        </div>
                                        <div class="bg-lightest p-10 rounded5 dvPreview text-center cove_desktop_en_controller_2"
                                            style="width: 100%;margin-top: 1em;height: 10em;">

                                            @if (!empty($theoryPackage->cove_desktop_en) && file_exists(public_path() . '/' . $theoryPackage->cove_desktop_en))
                                                @if (in_array(pathinfo($theoryPackage->cove_desktop_en, PATHINFO_EXTENSION), [
                                                        'JPG',
                                                        'jpg',
                                                        'jpeg',
                                                        'gif',
                                                        'png',
                                                        'bmp',
                                                    ]))
                                                    <img style="max-width: 100%;height: 100%;"
                                                        src="{{ url('/' . $theoryPackage->cove_desktop_en) }}"
                                                        alt="">
                                                    <video style="max-width: 100%;height: 100%;display: none;" controls
                                                        autoplay>
                                                    </video>
                                                @else
                                                    <img style="max-width: 100%;height: 100%;display: none;"
                                                        src="{{ url('/images/noimg.png') }}" alt="">
                                                    <video style="max-width: 100%;height: 100%;"
                                                        src="{{ url('/' . $theoryPackage->cove_desktop_en) }}" controls
                                                        autoplay>
                                                    </video>
                                                @endif
                                            @else
                                                <img style="max-width: 100%;height: 100%;"
                                                    src="{{ url('/images/noimg.png') }}" alt="">
                                                <video style="max-width: 100%;height: 100%;display: none;" controls
                                                    autoplay>
                                                </video>
                                            @endif
                                        </div>
                                    </div>
                                    @error('cove_desktop_en')
                                        <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                        </div>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="col-lg-12 mx-auto">
                                    <div class="custom-file-container_2">
                                        <div class="cove_phone_en_2">
                                            <input type="file" name="cove_phone_en" class="cove_phone_en_2"
                                                id="cove_phone_en">
                                            <label class="custom-file-label"
                                                for="cove_phone_en">{{ trans('messages.cove_phone_en') }}</label>
                                        </div>
                                        <div class="bg-lightest p-10 rounded5 dvPreview text-center cove_phone_en_controller_2"
                                            style="width: 100%;margin-top: 1em;height: 10em;">

                                            @if (!empty($theoryPackage->cove_phone_en) && file_exists(public_path() . '/' . $theoryPackage->cove_phone_en))
                                                @if (in_array(pathinfo($theoryPackage->cove_phone_en, PATHINFO_EXTENSION), ['JPG', 'jpg', 'jpeg', 'gif', 'png', 'bmp']))
                                                    <img style="max-width: 100%;height: 100%;"
                                                        src="{{ url('/' . $theoryPackage->cove_phone_en) }}"
                                                        alt="">
                                                    <video style="max-width: 100%;height: 100%;display: none;" controls
                                                        autoplay>
                                                    </video>
                                                @else
                                                    <img style="max-width: 100%;height: 100%;display: none;"
                                                        src="{{ url('/images/noimg.png') }}" alt="">
                                                    <video style="max-width: 100%;height: 100%;"
                                                        src="{{ url('/' . $theoryPackage->cove_phone_en) }}" controls
                                                        autoplay>
                                                    </video>
                                                @endif
                                            @else
                                                <img style="max-width: 100%;height: 100%;"
                                                    src="{{ url('/images/noimg.png') }}" alt="">
                                                <video style="max-width: 100%;height: 100%;display: none;" controls
                                                    autoplay>
                                                </video>
                                            @endif
                                        </div>
                                    </div>
                                    @error('cove_phone_en')
                                        <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                        </div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group">
                                <div class="col-lg-12 mx-auto">
                                    <div class="custom-file-container_2">
                                        <div class="cove_desktop_nl_2">
                                            <input type="file" name="cove_desktop_nl" class="cove_desktop_nl_2"
                                                id="cove_desktop_nl">
                                            <label class="custom-file-label"
                                                for="cove_desktop_nl">{{ trans('messages.cove_desktop_nl') }}</label>
                                        </div>
                                        <div class="bg-lightest p-10 rounded5 dvPreview text-center cove_desktop_controller_nl_2"
                                            style="width: 100%;margin-top: 1em;height: 10em;">
                                            @if (!empty($theoryPackage->cove_desktop_nl) && file_exists(public_path() . '/' . $theoryPackage->cove_desktop_nl))
                                                @if (in_array(pathinfo($theoryPackage->cove_desktop_nl, PATHINFO_EXTENSION), [
                                                        'JPG',
                                                        'jpg',
                                                        'jpeg',
                                                        'gif',
                                                        'png',
                                                        'bmp',
                                                    ]))
                                                    <img style="max-width: 100%;height: 100%;"
                                                        src="{{ url('/' . $theoryPackage->cove_phone_en) }}"
                                                        alt="">
                                                    <video style="max-width: 100%;height: 100%;display: none;" controls
                                                        autoplay>
                                                    </video>
                                                @else
                                                    <img style="max-width: 100%;height: 100%;display: none;"
                                                        src="{{ url('/images/noimg.png') }}" alt="">
                                                    <video style="max-width: 100%;height: 100%;"
                                                        src="{{ url('/' . $theoryPackage->cove_desktop_nl) }}" controls
                                                        autoplay>
                                                    </video>
                                                @endif
                                            @else
                                                <img style="max-width: 100%;height: 100%;"
                                                    src="{{ url('/images/noimg.png') }}" alt="">
                                                <video style="max-width: 100%;height: 100%;display: none;" controls
                                                    autoplay>
                                                </video>
                                            @endif
                                        </div>
                                    </div>
                                    @error('cove_desktop_nl')
                                        <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                        </div>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="col-lg-12 mx-auto">
                                    <div class="custom-file-container_2">
                                        <div class="cove_phone_nl_2">
                                            <input type="file" name="cove_phone_nl" class="cove_phone_nl_2"
                                                id="cove_phone_nl">
                                            <label class="custom-file-label"
                                                for="cove_phone_nl">{{ trans('messages.cove_phone_nl') }}</label>
                                        </div>
                                        <div class="bg-lightest p-10 rounded5 dvPreview text-center cove_phone_nl_controller_2"
                                            style="width: 100%;margin-top: 1em;height: 10em;">
                                            @if (!empty($theoryPackage->cove_phone_nl) && file_exists(public_path() . '/' . $theoryPackage->cove_phone_nl))
                                                @if (in_array(pathinfo($theoryPackage->cove_phone_nl, PATHINFO_EXTENSION), ['JPG', 'jpg', 'jpeg', 'gif', 'png', 'bmp']))
                                                    <img style="max-width: 100%;height: 100%;"
                                                        src="{{ url('/' . $theoryPackage->cove_phone_nl) }}"
                                                        alt="">
                                                    <video style="max-width: 100%;height: 100%;display: none;" controls
                                                        autoplay>
                                                    </video>
                                                @else
                                                    <img style="max-width: 100%;height: 100%;display: none;"
                                                        src="{{ url('/images/noimg.png') }}" alt="">
                                                    <video style="max-width: 100%;height: 100%;"
                                                        src="{{ url('/' . $theoryPackage->cove_phone_nl) }}" controls
                                                        autoplay>
                                                    </video>
                                                @endif
                                            @else
                                                <img style="max-width: 100%;height: 100%;"
                                                    src="{{ url('/images/noimg.png') }}" alt="">
                                                <video style="max-width: 100%;height: 100%;display: none;" controls
                                                    autoplay>
                                                </video>
                                            @endif
                                        </div>
                                    </div>
                                    @error('cove_phone_en')
                                        <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                        </div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <h2 class="panel-title">{{ trans('messages.Select Countries') }}</h2>
                        @foreach ($countries as $country)
                            @php
                                $columnName = 'country_' . $country->code;
                                $isChecked = isset($theoryPackage->$columnName) && $theoryPackage->$columnName == 1;
                            @endphp
                            <div class="checkbox">
                                <input type="checkbox" name="country_{{ $country->code }}"
                                    id="country_{{ $country->code }}" value="1"
                                    {{ $isChecked ? 'checked="checked"' : '' }} />
                                <label for="country_{{ $country->code }}">
                                    {{ $country->name }} ({{ $country->code }})
                                </label>
                            </div>
                        @endforeach
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer">
                        <button type="submit" class="btn btn-rounded btn-primary btn-outline">
                            <i class="ti-save-alt"></i> {{ trans('messages.Save') }}
                        </button>
                    </div>
                </div>
            </div>
        </div>
        {!! Form::Close() !!}
    </section>
@endsection
@section('script')
    <script type="text/javascript">
        $('.select2').select2();
        CKEDITOR.replace('editor1')
        CKEDITOR.replace('editoren')
        CKEDITOR.replace('editor2')
        $(document).ready(function() {
            // $(window).keydown(function(event) {
            //     if (event.keyCode == 13) {
            //         event.preventDefault();
            //         return false;
            //     }
            // });
        });
        $(".custom-file-input").change(function() {

            var fileInput = $(this)[0].files[0];
            var container = $(this).parents('.custom-file-container').find('.customer_file_input_conto');
            var imgSrc = container.find("img").length ? container.find("img") : null;
            var videoSrc = container.find("video").length ? container.find("video") : null;
            var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.jpg|.jpeg|.gif|.png|.bmp|.mp4|.mkv|.avi)$/;
            if (!fileInput) {
                alert("Please select a file.");
                return;
            }
            if (!regex.test(fileInput.name.toLowerCase())) {
                alert("Invalid file type. Please upload a valid image or video file.");
                imgSrc && imgSrc.attr("src", "").hide();
                videoSrc && videoSrc.remove();
                return;
            }
            var fileType = fileInput.type; // نوع الملف
            if (fileType.startsWith("image/") || fileType.startsWith("video/")) {
                if (typeof(FileReader) !== "undefined") {
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        if (fileType.startsWith("image/")) {
                            if (imgSrc) {

                                videoSrc && videoSrc.hide();
                                imgSrc.attr("src", e.target.result).show();
                            } else {
                                alert("No image container found to display the uploaded image.");
                            }
                        } else if (fileType.startsWith("video/")) {
                            if (videoSrc) {
                                // إذا كان هناك عنصر فيديو
                                imgSrc && imgSrc.hide(); // إخفاء الصورة إذا كانت موجودة
                                videoSrc.attr("src", e.target.result).show(); // عرض الفيديو
                            } else {
                                // إذا لم يكن هناك عنصر فيديو، يتم إنشاؤه
                                videoSrc = $(
                                    '<video controls autoplay style="width: 100%; height: auto;"></video>');
                                container.append(videoSrc);
                                videoSrc.attr("src", e.target.result).show();
                            }
                        }
                    };
                    reader.readAsDataURL(fileInput);
                } else {
                    alert("This browser does not support FileReader.");
                }
            } else {
                alert("Invalid file type. Please upload an image or video.");
            }
        });
        $(".custom-file-input_2").change(function() {
            var fileInput = $(this)[0].files[0];
            var container = $(this).parents('.custom-file-container_2').find('.custem-css-templet_2');
            var imgSrc = container.find("img").length ? container.find("img") : null;
            var videoSrc = container.find("video").length ? container.find("video") : null;
            var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.jpg|.jpeg|.gif|.png|.bmp|.mp4|.mkv|.avi)$/;
            if (!fileInput) {
                alert("Please select a file.");
                return;
            }
            if (!regex.test(fileInput.name.toLowerCase())) {
                alert("Invalid file type. Please upload a valid image or video file.");
                imgSrc && imgSrc.attr("src", "").hide();
                videoSrc && videoSrc.remove();
                return;
            }
            var fileType = fileInput.type; // نوع الملف
            if (fileType.startsWith("image/") || fileType.startsWith("video/")) {
                if (typeof(FileReader) !== "undefined") {
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        if (fileType.startsWith("image/")) {
                            if (imgSrc) {

                                videoSrc && videoSrc.hide();
                                imgSrc.attr("src", e.target.result).show();
                            } else {
                                alert("No image container found to display the uploaded image.");
                            }
                        } else if (fileType.startsWith("video/")) {
                            if (videoSrc) {
                                // إذا كان هناك عنصر فيديو
                                imgSrc && imgSrc.hide(); // إخفاء الصورة إذا كانت موجودة
                                videoSrc.attr("src", e.target.result).show(); // عرض الفيديو
                            } else {
                                // إذا لم يكن هناك عنصر فيديو، يتم إنشاؤه
                                videoSrc = $(
                                    '<video controls autoplay style="width: 100%; height: auto;"></video>');
                                container.append(videoSrc);
                                videoSrc.attr("src", e.target.result).show();
                            }
                        }
                    };
                    reader.readAsDataURL(fileInput);
                } else {
                    alert("This browser does not support FileReader.");
                }
            } else {
                alert("Invalid file type. Please upload an image or video.");
            }
        });

        $(".cove_phone_ar_2").change(function() {
            var fileInput = $(this)[0].files[0];
            var container = $(this).parents('.custom-file-container_2').find('.cove_phone_ar_controller_2');
            var imgSrc = container.find("img").length ? container.find("img") : null;
            var videoSrc = container.find("video").length ? container.find("video") : null;
            var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.jpg|.jpeg|.gif|.png|.bmp|.mp4|.mkv|.avi)$/;
            if (!fileInput) {
                alert("Please select a file.");
                return;
            }
            if (!regex.test(fileInput.name.toLowerCase())) {
                alert("Invalid file type. Please upload a valid image or video file.");
                imgSrc && imgSrc.attr("src", "").hide();
                videoSrc && videoSrc.remove();
                return;
            }
            var fileType = fileInput.type; // نوع الملف
            if (fileType.startsWith("image/") || fileType.startsWith("video/")) {
                if (typeof(FileReader) !== "undefined") {
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        if (fileType.startsWith("image/")) {
                            if (imgSrc) {

                                videoSrc && videoSrc.hide();
                                imgSrc.attr("src", e.target.result).show();
                            } else {
                                alert("No image container found to display the uploaded image.");
                            }
                        } else if (fileType.startsWith("video/")) {
                            if (videoSrc) {
                                // إذا كان هناك عنصر فيديو
                                imgSrc && imgSrc.hide(); // إخفاء الصورة إذا كانت موجودة
                                videoSrc.attr("src", e.target.result).show(); // عرض الفيديو
                            } else {
                                // إذا لم يكن هناك عنصر فيديو، يتم إنشاؤه
                                videoSrc = $(
                                    '<video controls autoplay style="width: 100%; height: auto;"></video>');
                                container.append(videoSrc);
                                videoSrc.attr("src", e.target.result).show();
                            }
                        }
                    };
                    reader.readAsDataURL(fileInput);
                } else {
                    alert("This browser does not support FileReader.");
                }
            } else {
                alert("Invalid file type. Please upload an image or video.");
            }
        });
        $(".cove_desktop_en_2").change(function() {
            var fileInput = $(this)[0].files[0];
            var container = $(this).parents('.custom-file-container_2').find('.cove_desktop_en_controller_2');
            var imgSrc = container.find("img").length ? container.find("img") : null;
            var videoSrc = container.find("video").length ? container.find("video") : null;
            var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.jpg|.jpeg|.gif|.png|.bmp|.mp4|.mkv|.avi)$/;
            if (!fileInput) {
                alert("Please select a file.");
                return;
            }
            if (!regex.test(fileInput.name.toLowerCase())) {
                alert("Invalid file type. Please upload a valid image or video file.");
                imgSrc && imgSrc.attr("src", "").hide();
                videoSrc && videoSrc.remove();
                return;
            }
            var fileType = fileInput.type; // نوع الملف
            if (fileType.startsWith("image/") || fileType.startsWith("video/")) {
                if (typeof(FileReader) !== "undefined") {
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        if (fileType.startsWith("image/")) {
                            if (imgSrc) {

                                videoSrc && videoSrc.hide();
                                imgSrc.attr("src", e.target.result).show();
                            } else {
                                alert("No image container found to display the uploaded image.");
                            }
                        } else if (fileType.startsWith("video/")) {
                            if (videoSrc) {
                                // إذا كان هناك عنصر فيديو
                                imgSrc && imgSrc.hide(); // إخفاء الصورة إذا كانت موجودة
                                videoSrc.attr("src", e.target.result).show(); // عرض الفيديو
                            } else {
                                // إذا لم يكن هناك عنصر فيديو، يتم إنشاؤه
                                videoSrc = $(
                                    '<video controls autoplay style="width: 100%; height: auto;"></video>');
                                container.append(videoSrc);
                                videoSrc.attr("src", e.target.result).show();
                            }
                        }
                    };
                    reader.readAsDataURL(fileInput);
                } else {
                    alert("This browser does not support FileReader.");
                }
            } else {
                alert("Invalid file type. Please upload an image or video.");
            }
        });
        $(".cove_phone_en_2").change(function() {
            var fileInput = $(this)[0].files[0];
            var container = $(this).parents('.custom-file-container_2').find('.cove_phone_en_controller_2');
            var imgSrc = container.find("img").length ? container.find("img") : null;
            var videoSrc = container.find("video").length ? container.find("video") : null;
            var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.jpg|.jpeg|.gif|.png|.bmp|.mp4|.mkv|.avi)$/;
            if (!fileInput) {
                alert("Please select a file.");
                return;
            }
            if (!regex.test(fileInput.name.toLowerCase())) {
                alert("Invalid file type. Please upload a valid image or video file.");
                imgSrc && imgSrc.attr("src", "").hide();
                videoSrc && videoSrc.remove();
                return;
            }
            var fileType = fileInput.type; // نوع الملف
            if (fileType.startsWith("image/") || fileType.startsWith("video/")) {
                if (typeof(FileReader) !== "undefined") {
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        if (fileType.startsWith("image/")) {
                            if (imgSrc) {

                                videoSrc && videoSrc.hide();
                                imgSrc.attr("src", e.target.result).show();
                            } else {
                                alert("No image container found to display the uploaded image.");
                            }
                        } else if (fileType.startsWith("video/")) {
                            if (videoSrc) {
                                // إذا كان هناك عنصر فيديو
                                imgSrc && imgSrc.hide(); // إخفاء الصورة إذا كانت موجودة
                                videoSrc.attr("src", e.target.result).show(); // عرض الفيديو
                            } else {
                                // إذا لم يكن هناك عنصر فيديو، يتم إنشاؤه
                                videoSrc = $(
                                    '<video controls autoplay style="width: 100%; height: auto;"></video>');
                                container.append(videoSrc);
                                videoSrc.attr("src", e.target.result).show();
                            }
                        }
                    };
                    reader.readAsDataURL(fileInput);
                } else {
                    alert("This browser does not support FileReader.");
                }
            } else {
                alert("Invalid file type. Please upload an image or video.");
            }
        });
        $(".cove_phone_nl_2").change(function() {
            var fileInput = $(this)[0].files[0];
            var container = $(this).parents('.custom-file-container_2').find('.cove_phone_nl_controller_2');
            var imgSrc = container.find("img").length ? container.find("img") : null;
            var videoSrc = container.find("video").length ? container.find("video") : null;
            var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.jpg|.jpeg|.gif|.png|.bmp|.mp4|.mkv|.avi)$/;
            if (!fileInput) {
                alert("Please select a file.");
                return;
            }
            if (!regex.test(fileInput.name.toLowerCase())) {
                alert("Invalid file type. Please upload a valid image or video file.");
                imgSrc && imgSrc.attr("src", "").hide();
                videoSrc && videoSrc.remove();
                return;
            }
            var fileType = fileInput.type; // نوع الملف
            if (fileType.startsWith("image/") || fileType.startsWith("video/")) {
                if (typeof(FileReader) !== "undefined") {
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        if (fileType.startsWith("image/")) {
                            if (imgSrc) {

                                videoSrc && videoSrc.hide();
                                imgSrc.attr("src", e.target.result).show();
                            } else {
                                alert("No image container found to display the uploaded image.");
                            }
                        } else if (fileType.startsWith("video/")) {
                            if (videoSrc) {
                                // إذا كان هناك عنصر فيديو
                                imgSrc && imgSrc.hide(); // إخفاء الصورة إذا كانت موجودة
                                videoSrc.attr("src", e.target.result).show(); // عرض الفيديو
                            } else {
                                // إذا لم يكن هناك عنصر فيديو، يتم إنشاؤه
                                videoSrc = $(
                                    '<video controls autoplay style="width: 100%; height: auto;"></video>');
                                container.append(videoSrc);
                                videoSrc.attr("src", e.target.result).show();
                            }
                        }
                    };
                    reader.readAsDataURL(fileInput);
                } else {
                    alert("This browser does not support FileReader.");
                }
            } else {
                alert("Invalid file type. Please upload an image or video.");
            }
        });
        $(".cove_desktop_nl_2").change(function() {
            var fileInput = $(this)[0].files[0];
            var container = $(this).parents('.custom-file-container_2').find('.cove_desktop_controller_nl_2');
            var imgSrc = container.find("img").length ? container.find("img") : null;
            var videoSrc = container.find("video").length ? container.find("video") : null;
            var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.jpg|.jpeg|.gif|.png|.bmp|.mp4|.mkv|.avi)$/;
            if (!fileInput) {
                alert("Please select a file.");
                return;
            }
            if (!regex.test(fileInput.name.toLowerCase())) {
                alert("Invalid file type. Please upload a valid image or video file.");
                imgSrc && imgSrc.attr("src", "").hide();
                videoSrc && videoSrc.remove();
                return;
            }
            var fileType = fileInput.type; // نوع الملف
            if (fileType.startsWith("image/") || fileType.startsWith("video/")) {
                if (typeof(FileReader) !== "undefined") {
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        if (fileType.startsWith("image/")) {
                            if (imgSrc) {

                                videoSrc && videoSrc.hide();
                                imgSrc.attr("src", e.target.result).show();
                            } else {
                                alert("No image container found to display the uploaded image.");
                            }
                        } else if (fileType.startsWith("video/")) {
                            if (videoSrc) {
                                // إذا كان هناك عنصر فيديو
                                imgSrc && imgSrc.hide(); // إخفاء الصورة إذا كانت موجودة
                                videoSrc.attr("src", e.target.result).show(); // عرض الفيديو
                            } else {
                                // إذا لم يكن هناك عنصر فيديو، يتم إنشاؤه
                                videoSrc = $(
                                    '<video controls autoplay style="width: 100%; height: auto;"></video>');
                                container.append(videoSrc);
                                videoSrc.attr("src", e.target.result).show();
                            }
                        }
                    };
                    reader.readAsDataURL(fileInput);
                } else {
                    alert("This browser does not support FileReader.");
                }
            } else {
                alert("Invalid file type. Please upload an image or video.");
            }
        });
        $(".cove_desktop_ar-input").change(function() {
            var fileInput = $(this)[0].files[0];
            var container = $(this).parents('.custom-file-container').find('.cove_desktop_contorller_ar');
            var imgSrc = container.find("img").length ? container.find("img") : null;
            var videoSrc = container.find("video").length ? container.find("video") : null;
            var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.jpg|.jpeg|.gif|.png|.bmp|.mp4|.mkv|.avi)$/;
            if (!fileInput) {
                alert("Please select a file.");
                return;
            }
            if (!regex.test(fileInput.name.toLowerCase())) {
                alert("Invalid file type. Please upload a valid image or video file.");
                imgSrc && imgSrc.attr("src", "").hide();
                videoSrc && videoSrc.remove();
                return;
            }
            var fileType = fileInput.type; // نوع الملف
            if (fileType.startsWith("image/") || fileType.startsWith("video/")) {
                if (typeof(FileReader) !== "undefined") {
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        if (fileType.startsWith("image/")) {
                            if (imgSrc) {

                                videoSrc && videoSrc.hide();
                                imgSrc.attr("src", e.target.result).show();
                            } else {
                                alert("No image container found to display the uploaded image.");
                            }
                        } else if (fileType.startsWith("video/")) {
                            if (videoSrc) {
                                // إذا كان هناك عنصر فيديو
                                imgSrc && imgSrc.hide(); // إخفاء الصورة إذا كانت موجودة
                                videoSrc.attr("src", e.target.result).show(); // عرض الفيديو
                            } else {
                                // إذا لم يكن هناك عنصر فيديو، يتم إنشاؤه
                                videoSrc = $(
                                    '<video controls autoplay style="width: 100%; height: auto;"></video>');
                                container.append(videoSrc);
                                videoSrc.attr("src", e.target.result).show();
                            }
                        }
                    };
                    reader.readAsDataURL(fileInput);
                } else {
                    alert("This browser does not support FileReader.");
                }
            } else {
                alert("Invalid file type. Please upload an image or video.");
            }
        });
    </script>
@endsection
