@extends('admin.layouts.main')
@section('content')
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title"> {{ trans('messages.offers') }}</h3>
            </div>

        </div>
    </div>
    <style>
        .offer-active {
            background-color: #FFF !important;
            border-color: #1221db !important;
            color: #0ee31e !important;
        }
    </style>
    <!-- Main content -->
    <section class="content">
        <div class="box">
            <div class="box-header">
                <div class="col" style="text-align: end">
                    @can('package_cerate_edit_offer')
                        <a href="#" onclick="createOffer({{ $packageId }})"
                            class="waves-effect waves-light btn btn-primary-light btn-circle"><span class="mdi mdi-plus"><span
                                    class="path1"></span><span class="path2"></span></span></a>
                    @endcan
                </div>
            </div>
            <div class="box-body no-padding">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr class="">
                                <th class="text-center">
                                    #
                                </th>
                                <th class="text-center">{{ trans('messages.Name') }}</th>
                                <th class="text-center">{{ trans('messages.Discount amount') }}</th>
                                <th class="text-center">{{ trans('messages.Start date') }}</th>
                                <th class="text-center">{{ trans('messages.Expiration duration') }}</th>
                                <th class="text-center">{{ trans('messages.Created') }}</th>
                                <th class="text-center">{{ trans('messages.status') }}</th>
                                <th class="text-center">{{ trans('messages.countries') }}</th>
                                <th class="text-center">{{ trans('messages.Options') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($offers as $key => $offer)
                                <tr>
                                    <td class="text-center">
                                        {{ $key + 1 }}
                                    </td>
                                    <td class="text-center">{{ $offer->title }}</td>
                                    <td class="text-center">{{ $offer->discount_amount }}</td>
                                    <td class="text-center">{{ $offer->start_date }}</td>
                                    <td class="text-center">{{ $offer->end_date }}</td>
                                    <td class="text-center">{{ $offer->created_at }}</td>
                                    <td class="text-center">
                                        @php
                                            $now = now();
                                            $isActive =
                                                $offer->start_date <= $now &&
                                                (!$offer->end_date || $offer->end_date >= $now);
                                        @endphp

                                        <div class="badge {{ $isActive ? 'badge-success' : 'badge-danger' }}">
                                            {{ $isActive ? trans('messages .Active') : trans('messages .Inactive / Expired') }}
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        @forelse ($offer->country_tags as $countryCode => $status)
                                            <span class="badge bg-primary me-1">
                                                {{ $countryCode }}
                                            </span>
                                        @empty
                                            <div class="badge badge-danger">
                                                {{ trans('messages.Not Assigned') }}
                                            </div>
                                        @endforelse
                                    </td>
                                    <td class="text-center">
                                        @can('package_cerate_edit_offer')
                                            <form action="{{ route('offer.deactivateOffer', $offer->id) }}" method="POST"
                                                style="display: inline;">
                                                @csrf
                                                <button type="submit"
                                                    onclick="return confirm('Are you sure you want to deactivate this offer?')"
                                                    title="{{ trans('messages.delete offer') }}"
                                                    class="waves-effect waves-light btn btn-primary-light btn-circle"
                                                    style="background: none; border: none; padding: 0; cursor: pointer;">
                                                    <span class="icon-Trash1" style="color: red;">
                                                        <span class="path1"></span>
                                                        <span class="path2"></span>
                                                    </span>
                                                </button>
                                            </form>
                                        @endcan
                                        @can('package_cerate_edit_offer')
                                            <a href="#" onclick="updateOffer({{ $packageId }}, {{ $offer->id }})"
                                                class="waves-effect waves-light btn btn-primary-light btn-circle">
                                                <span class="icon-Write"><span class="path1"></span><span
                                                        class="path2"></span></span>
                                            </a>
                                        @endcan
                                    </td>
                                </tr>
                            @endforeach

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('modal')
    <div class="modal fade bs-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
        id="make-offer" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">

            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
@endsection
@section('script')
    <script type="text/javascript">
        function createOffer(id) {
            $.post(`{{ route('package.offerCreate') }}`, {
                _token: '{{ csrf_token() }}',
                id: id
            }, function(data) {
                $('#make-offer .modal-dialog .modal-content').html(data);
                $('#make-offer').modal();

            });
        }

        function updateOffer(packageId, offerId) {
            const url = "{{ route('package.offerEdit', ['package' => ':package', 'offer' => ':offer']) }}"
                .replace(':package', packageId)
                .replace(':offer', offerId);

            $.post(url, {
                _token: '{{ csrf_token() }}'
            }, function(data) {
                $('#make-offer .modal-dialog .modal-content').html(data);
                $('#make-offer').modal();
            });
        }
    </script>
@endsection
