@extends('admin.layouts.main')
@section('content')
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title">{{ trans('messages.Notification') }}</h3>
            </div>

        </div>
    </div>

    <style>
        .bootstrap-tagsinput {
            width: 100%;
            padding: 0.6em;
        }
    </style>
    <!-- Main content -->

    <section class="content">
        {!! Form::open([
            'route' => 'notification.sendNotificationToTopic',
            'files' => true,
            'id' => 'send-notification-form',
        ]) !!}
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="box">
                    <div class="box-body">
                        <div class="form-group">
                            <label for="title">{{ trans('messages.Title') }}
                            </label>
                            <div>
                                {!! Form::text('title', null, ['class' => 'form-control', 'placeholder' => trans('messages.Title')]) !!}
                            </div>
                            @error('title')
                                <div class="badge badge-danger text-center" style="width: 100%">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for="body">{{ trans('messages.Body') }}
                            </label>
                            <div>
                                {!! Form::text('body', null, ['class' => 'form-control', 'placeholder' => trans('messages.Body')]) !!}
                            </div>
                            @error('body')
                                <div class="badge badge-danger text-center" style="width: 100%">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for="action">{{ trans('messages.Action') }}</label>
                            <div>
                                {!! Form::select(
                                    'action',
                                    [
                                        'general' => 'General',
                                        'course' => 'Course',
                                        'package_exam' => 'Package Exam',
                                        'package_video' => 'Package Video',
                                    ],
                                    null,
                                    [
                                        'class' => 'form-control',
                                        'id' => 'action',
                                        'data-placeholder' => trans('messages.Add Name'),
                                    ],
                                ) !!}
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="topic">{{ trans('messages.topic') }}</label>
                            <div>
                                {!! Form::select(
                                    'topic',
                                    [
                                        'ia' => 'IA',
                                        'ae' => 'AE',
                                        'sa' => 'SA',
                                    ],
                                    null,
                                    [
                                        'class' => 'form-control',
                                        'id' => 'topic',
                                        'data-placeholder' => trans('messages.Add country'),
                                    ],
                                ) !!}
                            </div>
                        </div>
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer">
                        <button type="submit" class="btn btn-rounded btn-primary btn-outline">
                            <i class="ti-save-alt"></i> {{ trans('messages.Send') }}
                        </button>
                    </div>
                </div>
            </div>
        </div>
        {!! Form::Close() !!}
    </section>
@endsection


@section('script')
    <script type="text/javascript">
        $('.select2').select2();
        CKEDITOR.replace('editor1')
        CKEDITOR.replace('editoren')
        CKEDITOR.replace('editor2')
        $(document).ready(function() {
            $(window).keydown(function(event) {
                if (event.keyCode == 13) {
                    event.preventDefault();
                    return false;
                }
            });
        });
    </script>
@endsection
