@extends('admin.layouts.main')
@section('content')
    <!-- Content Header (Page header) -->
    {{-- @if ($message = Session::get('success'))
        <div class="alert alert-success">
            <p>{{ $message }}</p>
        </div>
    @endif --}}
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title"> {{ trans('messages.Clients') }}</h3>
            </div>

        </div>
    </div>
    <!-- Main content -->
    <section class="content">
        <div class="box">
            <div class="box-header">
                <div class="row">
                    <div class="col-4">
                        <div class="app-menu">
                            <div class="search-bx mx-5">
                                <form action="{{ route('client.index') }}" method="GET">
                                    <div class="input-group">
                                        <input type="search" id="search" class="form-control" name="search"
                                            @isset($sort_search) value="{{ $sort_search }}" @endisset
                                            placeholder="{{ trans('messages.Name') }}" aria-label="Search"
                                            aria-describedby="button-addon2">
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col" style="text-align: end">
                        @can('client_create')
                            <a href="{{ route('client.create') }}"
                                class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                    class="mdi mdi-plus"><span class="path1"></span><span class="path2"></span></span></a>
                        @endcan

                    </div>
                </div>

            </div>
            <div class="box-body no-padding">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr class="">
                                <th class="text-center">
                                    #
                                </th>
                                <th class="text-center">{{ trans('messages.Name') }}</th>
                                <th class="text-center">{{ trans('messages.Email') }}</th>
                                <th class="text-center">{{ trans('messages.Created') }}</th>
                                <th class="text-center">{{ trans('messages.countries') }}</th>
                                <th class="text-center">{{ trans('messages.Language') }}</th>
                                <th class="text-center">{{ trans('messages.Options') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($clients as $key => $client)
                                <tr>
                                    <td class="text-center">
                                        {{ $key + 1 + ($clients->currentPage() - 1) * $clients->perPage() }}
                                    </td>
                                    <td class="text-center">{{ $client->name }}</td>
                                    <td class="text-center">{{ $client->email }}</td>
                                    <td class="text-center">{{ $client->created_at }}</td>
                                    <td class="text-center">
                                        @if ($client->country_code)
                                            <span
                                                class="badge bg-primary me-1">{{ strtoupper($client->country_code) }}</span>
                                        @else
                                            <div class="badge badge-danger">
                                                {{ trans('messages.Not Assigned') }}
                                            </div>
                                        @endif
                                    </td>
                                    <td class="text-center">
                                        @if ($client->language_code)
                                            <span
                                                class="badge bg-primary me-1">{{ strtoupper($client->language_code) }}</span>
                                        @else
                                            <div class="badge badge-danger">
                                                {{ trans('messages.Not Assigned') }}
                                            </div>
                                        @endif
                                    </td>
                                    <td class="text-center">
                                        @can('client_delete')
                                            <form action="{{ route('client.destroy', $client->id) }}" method="Post"
                                                id="destroy-form-{{ $client->id }}">
                                                @csrf
                                                @method('DELETE')
                                            </form>
                                        @endcan
                                        @can('client_view')
                                            <a href="{{ route('client.show', $client->id) }}"
                                                class="waves-effect waves-light btn btn-primary-light btn-circle mx-5"><span
                                                    class="mdi mdi-magnify"><span class="path1"></span><span
                                                        class="path2"></span></span></a>
                                        @endcan
                                        @can('client_update')
                                            <a href="{{ route('client.edit', $client->id) }}"
                                                class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                                    class="icon-Write"><span class="path1"></span><span
                                                        class="path2"></span></span></a>
                                        @endcan
                                        @can('client_delete')
                                            <a data-title="{{ trans('messages.Are you sure?') }}"
                                                data-no="{{ trans('messages.Cancel') }}"
                                                data-yes="{{ trans('messages.Yes, delete it!') }}"
                                                data-desc="{{ trans('messages.You will not be able to recover this!') }}"
                                                href="#" data-href="{{ $client->id }}"
                                                class="sa-warning waves-effect waves-light btn btn-primary-light btn-circle"><span
                                                    class="icon-Trash1"><span class="path1"></span><span
                                                        class="path2"></span></span></a>
                                        @endcan
                                    </td>
                                </tr>
                            @endforeach

                        </tbody>
                    </table>
                    {!! $clients->withQueryString()->links('pagination::bootstrap-4') !!}

                </div>
            </div>
        </div>
    </section>
@endsection
@section('modal')
    <div class="modal modal-left fade" id="modal-left" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content" id="view-company">

            </div>
        </div>
    </div>
@endsection
@section('script')
    <script type="text/javascript"></script>
@endsection
