<?php

namespace App\Sys\Services\Questions;

use App\Sys\Services;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Validator;
use App\Sys\Repositories\Questions\FavoriteQuestionRepository;

class FavoriteQuestionService extends Services
{
    protected $favoriteQuestionRepository;

    public function __construct(FavoriteQuestionRepository $favoriteQuestionRepository)
    {
        $this->favoriteQuestionRepository = $favoriteQuestionRepository;
    }

    public function getFavoriteQuestions($limit, $userId)
    {
        return $this->favoriteQuestionRepository->getFavoriteQuestions($limit, $userId);
    }

    public function getSelectedFavoriteQuestion($userId, $favoriteId)
    {
        $rules = [
            'favorite_id' => [
                'required',
                'integer',
                'exists:favorite_questions,id,user_id,' . $userId,
            ],
        ];

        $data = ['favorite_id' => $favoriteId];

        $validator = Validator::make($data, $rules);

        if ($validator->fails()) {
            $this->setError($validator->errors());
            return false;
        }

        return $this->favoriteQuestionRepository->getSelectedFavoriteQuestion($userId, $favoriteId);
    }
}
