<?php

namespace App\Sys\Repositories\Theories;

use App\Models\TheoryPackage;

class TheoryPackageRepository
{
    public function getPaginatedTheories($limit)
    {
        $countryCode = config('app.country');

        return TheoryPackage::query()
            ->where('country_' . $countryCode, true)
            ->where('enable', 1)
            ->latest()
            ->paginate($limit);
    }

    public function getSelectedTheory($theoryId, $user)
    {
        return TheoryPackage::query()
            ->where('country_' . $user->countryCode, true)
            ->where('enable', 1)
            ->find($theoryId);
    }
}
