<?php

namespace App\Sys\Repositories\Questions;

use App\Models\FavoriteQuestion;

class FavoriteQuestionRepository
{
    public function getFavoriteQuestions($limit, $userId)
    {
        return FavoriteQuestion::where('user_id', $userId)
            ->with('question')
            ->paginate($limit);
    }

    public function getSelectedFavoriteQuestion($userId, $favoriteId)
    {
        return FavoriteQuestion::where('user_id', $userId)
            ->where('id', $favoriteId)
            ->with('question')->first();
    }
}
