<?php

namespace App\Sys\Repositories\Packages;

use App\Models\Package;

class PackageRepository
{
    public function getActivePackages($limit)
    {
        $countryCode = config('app.country');

        return Package::query()
            ->with(['offer' => function ($query) use ($countryCode) {
                $query->where('country_' . $countryCode, true);
            }])
            ->where('country_' . $countryCode, true)
            ->where('active', 1)
            ->orderBy('arrangement_phone')
            ->paginate($limit);
    }
}
