<?php

namespace App\Sys\Repositories\General;

use App\Models\Page;

class StaticPageRepository
{
    public function getStaticContent()
    {
        $country = config('app.country');

        return Page::where('enabel', true)
            ->where('country_' . $country, true)
            ->select('id', 'title_ar', 'title_en', 'title_nl')
            ->get();
    }

    public function getStaticContentById($id)
    {
        return Page::findOrFail($id);
    }
}
