<?php

namespace App\Models;

use App\Traits\HasCountryTags;
use Illuminate\Support\Facades\App;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PackageVideoOffers extends Model
{

    use softDeletes, HasCountryTags;

    protected $appends = ['countryTags', 'title'];
    protected $table = 'package_video_offers';

    public function package()
    {
        return $this->belongsTo(PackageVideo::class, 'package_id')->orderBy('arrangement', 'ASC');
    }

    public function getTitleAttribute()
    {
        return $this->{'title_' . App::getLocale()} == null ? $this->title_ar : $this->{'title_' . App::getLocale()};
    }
}
