<?php

namespace App\Models;

use App\Traits\HasCountryTags;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\App;

class Offer extends Model
{
    use HasFactory, HasCountryTags;
    protected $appends = ['title', 'countryTags'];
    protected $fillable = [
        'country_ia',
        'country_sa',
        'country_ae',
        'title_ar',
        'title_en',
        'title_nl',
        'package_id',
        'start_date',
        'end_date',
        'discount_amount'
    ];

    public function getTitleAttribute()
    {
        return $this->{'title_' . App::getLocale()} == null ? $this->title_ar : $this->{'title_' . App::getLocale()};
    }

    public function package()
    {
        return $this->belongsTo(Package::class, 'package_id')->orderBy('arrangement', 'ASC');
    }
}
