<?php

namespace App\Models;

use App\Traits\HasCountryTags;
use Illuminate\Support\Facades\App;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Exam extends Model
{
    use HasFactory, HasCountryTags;

    protected $appends = ['examName', 'description', 'photo'];

    public function getExamNameAttribute()
    {
        return $this->{'name_' . App::getLocale()} == null ? $this->name_ar : $this->{'name_' . App::getLocale()};
    }
    public function getDescriptionAttribute()
    {
        return $this->{'description_' . App::getLocale()} == null ? $this->notes_ar : $this->{'description_' . App::getLocale()};
    }

    public function getPhotoAttribute()
    {
        return $this->photo_phone != null && file_exists(public_path() . '/' . $this->photo_phone) ? url('/' . $this->photo_phone) : null;
    }
    protected $fillable = [
        'active',
        'arrangment',
        'name_ar',
        'name_en',
        'name_nl',
        'description_ar',
        'description_en',
        'description_nl',
        'questions_num',
        'attempt_num',
        'duration_in_minutes',
        'exam_category_auto_move'
    ];

    public function packages()
    {
        return $this->belongsToMany(Package::class, 'package_exams', 'exam_id', 'package_id');
    }

    public function results()
    {
        return $this->hasMany(Result::class, 'exam_id');
    }

    public function questions()
    {
        return $this->hasMany(Question::class, 'exam_id');
    }

    public function examCategory()
    {
        return $this->hasMany(ExamCategory::class, 'exam_id')->orderBy('arrangment', 'asc');
    }
}
